<?php
class OrganicInternet_SimpleConfigurableProducts_Catalog_Model_Resource_Product_Indexer_Price_Configurable
    extends Mage_Catalog_Model_Resource_Eav_Mysql4_Product_Indexer_Price_Configurable
{
    protected function _isManageStock()
    {
        return Mage::getStoreConfigFlag(Mage_CatalogInventory_Model_Stock_Item::XML_PATH_MANAGE_STOCK);
    }

    #Don't pay any attention to cost of specific conf product options, as SCP doesn't use them
    protected function _applyConfigurableOption()
    {
        return $this;
    }

    #This calculates final price using SCP logic: minimal child product finalprice
    #instead of the just the entered configurable price
    #It uses a subquery/group-by hack to ensure that the various column values are all from the row with the lowest final price.
    #See Kasey Speakman comment here: http://dev.mysql.com/doc/refman/5.1/en/example-maximum-column-group-row.html
    #It's all quite complicated. :/
    protected function _prepareFinalPriceData($entityIds = null)
    {
        $this->_prepareDefaultFinalPriceTable();

        $stockStatusExpr = $this->_isManageStock() ?
            new Zend_Db_Expr('IF(cisi.use_config_manage_stock = 0 AND cisi.manage_stock = 0, 1, cisi.is_in_stock)') :
            new Zend_Db_Expr('IF(cisi.use_config_manage_stock = 0 AND cisi.manage_stock = 1, cisi.is_in_stock, 1)');

        $isInStockExpr = new Zend_Db_Expr("IF({$stockStatusExpr}, 1, 0)");
        $write = $this->_getWriteAdapter();

        // MODIFIED: Use CTE to obtain a windowed set based on sorting of price index, then sort this window.
        //
        // Newer MySQL/MariaDB versions produce results from a random row if we
        // do not use aggregate-functions or windowing-functions on all
        // non-grouped columns. The CTE allows us to rank the columns according
        // to a criteria (in-stock, final_price, price) and take the best
        // matching row.
        $cte = $write->select();

        $cte->from(["e" => $this->getTable("catalog/product")], ["entity_id"]);
        $cte->joinCross(["cis" => $this->getTable("cataloginventory/stock")], []);
        $cte->join(
            ["l" => $this->getTable("catalog/product_super_link")],
            "l.parent_id = e.entity_id",
            []
        );
        $cte->join(
            ["pi" => $this->getIdxTable()],
            "l.product_id = pi.entity_id",
            [
                "customer_group_id",
                "website_id",
                "tax_class_id",
                "price",
                "final_price",
                "tier_price",
                "group_price",
            ]
        );
        $cte->join(
            ["cw" => $this->getTable('core/website')],
            "pi.website_id = cw.website_id",
            []
        );
        $cte->join(
            ["csg" => $this->getTable("core/store_group")],
            "csg.website_id = cw.website_id AND cw.default_group_id = csg.group_id",
            []
        );
        $cte->join(
            ["cs" => $this->getTable("core/store")],
            "csg.default_store_id = cs.store_id AND cs.store_id <> 0",
            []
        );
        $cte->joinLeft(
            ["cisi" => $this->getTable("cataloginventory/stock_item")],
            "cisi.stock_id = cis.stock_id AND cisi.product_id = pi.entity_id",
            []
        );
        $cte->where("e.type_id = ?", $this->getTypeId());

        #Inner select order needs to be:
        #1st) If it's in stock come first (out of stock product prices aren't used if not-all products are out of stock)
        #2nd) Finalprice
        #3rd) $price, in case all finalPrices are NULL. (this gives the lowest price for all associated products when they're all out of stock)
        // We solve this by using RANK()
        $cte->columns([
            "rank" => new Zend_Db_Expr("RANK() OVER (PARTITION BY e.entity_id, pi.customer_group_id, pi.website_id ORDER BY $isInStockExpr DESC, pi.final_price ASC, pi.price ASC)"),
        ]);

        if(!is_null($entityIds)) {
            $cte->where('e.entity_id IN(?)', $entityIds);
        }

        Mage::dispatchEvent('prepare_catalog_product_index_select', array(
            'select'        => $cte,
            'entity_field'  => new Zend_Db_Expr('e.entity_id'),
            'website_field' => new Zend_Db_Expr('pi.website_id'),
            'store_field'   => new Zend_Db_Expr('cs.store_id')
        ));

        $max = $write->select();

        $max->from(["j" => "child_prices"], []);
        $max->columns([
            new Zend_Db_Expr("MAX(j.final_price)"),
        ]);
        $max->where("j.entity_id = child_prices.entity_id AND child_prices.customer_group_id = j.customer_group_id AND child_prices.website_id = j.website_id");

        $groupBy = ["entity_id", "customer_group_id", "website_id"];
        $insertSelect = $write->select();

        $insertSelect->from("child_prices", [
            "entity_id",
            "customer_group_id",
            "website_id",
            "tax_class_id",
            "orig_price" => "price",
            "price" => "final_price",
            "min_price" => "final_price",
            "tier_price" => "tier_price",
            "base_tier" => "tier_price",
            "group_price" => "group_price",
            "base_group_price" => "group_price",
        ]);
        $insertSelect->where("child_prices.rank = 1");
        $insertSelect->columns([
            "max_price" => $max,
        ]);
        $insertSelect->group($groupBy);

        $targetTable = $write->quoteIdentifier($this->_getDefaultFinalPriceTable());
        $cols = array_map(function($columnEntry) {
            list($correlationName, $column, $alias) = $columnEntry;

            return $column instanceof Zend_Db_Expr ? $alias : ($alias ?: $column);
        }, $insertSelect->getPart(Zend_Db_Select::COLUMNS));
        $insertCols = implode(", ", array_map([$write, "quoteIdentifier"], $cols));
        $onDuplicateCols = implode(", ", array_map(function($col) use($write) {
            $quoted = $write->quoteIdentifier($col);

            return sprintf("%s = VALUES(%s)", $quoted, $quoted);
        }, array_diff($cols, $groupBy)));

        $query = "INSERT INTO $targetTable ($insertCols) WITH child_prices AS ($cte) $insertSelect ON DUPLICATE KEY UPDATE $onDuplicateCols";

        $write->query($query);

        /**
         * Add possibility modify prices from external events
        */
        $select = $write->select()
            ->join(array('wd' => $this->_getWebsiteDateTable()),
                'i.website_id = wd.website_id',
                array());
        Mage::dispatchEvent('prepare_catalog_product_price_index_table', array(
            'index_table'       => array('i' => $this->_getDefaultFinalPriceTable()),
            'select'            => $select,
            'entity_id'         => 'i.entity_id',
            'customer_group_id' => 'i.customer_group_id',
            'website_id'        => 'i.website_id',
            'website_date'      => 'wd.website_date',
            'update_fields'     => array('price', 'min_price', 'max_price')
        ));

        return $this;
    }
}
