<?php

class Onelogin_SAML_SamlController extends Mage_Core_Controller_Front_Action
{
    public function indexAction() {
        $this->loginAction();
    }

    /**
     * Process login (HTTP-POST)
     */
    public function loginAction()
    {
        $customerSession = Mage::getSingleton('customer/session', array('name'=>'frontend'));

        if ($customerSession->isLoggedIn()) {
            $customerSession->logout();
        }

        if (!$customerSession->isLoggedIn()){
            $module_enabled = Mage::helper('onelogin_saml')->checkEnabledModule();
            if ($module_enabled) {
                $session = Mage::getSingleton("core/session", array("name" => "frontend"));

                $settingsInfo = Mage::helper('onelogin_saml')->getSettings();
                $settings = new OneLogin_Saml2_Settings($settingsInfo, true);

		$authNRequestXML = $this->createAuthNrequestXML($settingsInfo);

		if ($settingsInfo['security']['authnRequestsSigned']) {
                	$key = $settings->getSPkey();
	                $cert = $settings->getSPcert();

        	        $signatureAlgorithm = $signatureAlgorithm = Mage::getStoreConfig('onelogin_saml/advanced/signaturealgorithm');
        	        $sigAlg = isset($signatureAlgorithm)? $signatureAlgorithm : 'http://www.w3.org/2000/09/xmldsig#rsa-sha1';

        	        $signedAuthNRequestXML = OneLogin_Saml2_Utils::addSign($authNRequestXML, $key, $cert, $sigAlg);

        	        $encodedAuthNRequest = base64_encode($signedAuthNRequestXML);
		} else {
	            $encodedAuthNRequest = base64_encode($authNRequestXML);
        	}

                $redirectTo = $customerSession->getBeforeAuthUrl();
                if (!isset($redirectTo) || empty($redirectTo)) {
                    $redirectTo =  Mage::getBaseUrl();
                }

                $params = array(
                    'RelayState' => $redirectTo,
                    'SAMLRequest' => $encodedAuthNRequest
                );

                $idpData = $settings->getIdPData();
                $ssoURL = $idpData['singleSignOnService']['url'];
                $this->executePost($ssoURL, $params);
            } else {
                Mage::getSingleton('core/session')->addError("You tried to start a SSO process but Onelogin SAML module has disabled status");
                $this->_redirectUrl(Mage::getBaseUrl());
            }
        } else {
            Mage::getSingleton('core/session')->addError("You tried to start a SSO process but you are already logged");
            $this->_redirectUrl(Mage::getBaseUrl());
        }
    }

    /**
     * Process login (HTTP-Redirect)
     */
    public function loginActionRedirect()
    {
        $customerSession = Mage::getSingleton('customer/session', array('name'=>'frontend'));
        if (!$customerSession->isLoggedIn()){
            $module_enabled = Mage::helper('onelogin_saml')->checkEnabledModule();
            if ($module_enabled) {
                $session = Mage::getSingleton("core/session", array("name" => "frontend"));

                $redirectTo = $customerSession->getBeforeAuthUrl();
                if (!isset($redirectTo) || empty($redirectTo)) {
                    $redirectTo =  Mage::getBaseUrl();
                }
		
		if (isset($redirectTo) && !empty($redirectTo)) {
		    $parameters['RelayState'] = $redirectTo;
		}

                $settingsInfo = Mage::helper('onelogin_saml')->getSettings();
        	$authNRequestXML = $this->createAuthNrequestXML($settingsInfo);
	        $samlRequest = $this->deflateAndEncode($authNRequestXML);
		$parameters = [];
	        $parameters['SAMLRequest'] = $samlRequest;

		if ($settingsInfo['security']['authnRequestsSigned']) {
		    $auth = Mage::helper('onelogin_saml')->getAuth($settingsInfo);
		    $signature = $auth->buildRequestSignature($samlRequest, $parameters['RelayState'], $security['signatureAlgorithm']);
		    $parameters['SigAlg'] = $security['signatureAlgorithm'];
		    $parameters['Signature'] = $signature;
		}
		$ssoURL = $settingsInfo['idp']['singleSignOnService']['url'];
		Onelogin_Saml2_Utils::redirect($ssoURL, $parameters, false);
            } else {
                Mage::getSingleton('core/session')->addError("You tried to start a SSO process but Onelogin SAML module has disabled status");
                $this->_redirectUrl(Mage::getBaseUrl());
            }
        } else {
            Mage::getSingleton('core/session')->addError("You tried to start a SSO process but you are already logged");
            $this->_redirectUrl(Mage::getBaseUrl());
        }
    }

    /**
     * Process logout
     */
    public function logoutAction()
    {
        $module_enabled = Mage::helper('onelogin_saml')->checkEnabledModule();
        if ($module_enabled) {
            $slo_enabled = Mage::getStoreConfig('onelogin_saml/options/slo');
            if ($slo_enabled) {
                Mage::helper('onelogin_saml')->initSLO();
            }
        }
        Mage::getSingleton('core/session')->addError("You tried to SLO but was disabled, try local logout");
        $this->_redirectUrl(Mage::getBaseUrl());
    }

    /**
     * AssertionConsumerService. Process acs
     */
    public function acsAction()
    {
        try {
            Mage::helper('onelogin_saml')->processSSO();
        }
        catch(OneLogin_Saml2_Error $e) {
            if($e->getCode() !== OneLogin_Saml2_Error::SAML_RESPONSE_NOT_FOUND) {
                throw $e;
            }

            return $this->getResponse()->setHttpResponseCode(405);
        }
    }

    /**
     * Single Logout Service. Process sls
     */
    public function slsAction()
    {
        Mage::helper('onelogin_saml')->processSLO();
    }

    /**
     * Process logout
     */
    public function metadataAction()
    {
         Mage::helper('onelogin_saml')->printSPMetadata();
    }

    public function executePost($url, $params)
    {
        //Mage::log(sprintf("SAML executePost: url: %s, params: %s", $url, json_encode($params)));
        echo '<html>';

        echo '<body onload="document.getElementById(\'send\').click();">';
        echo '<form method="POST" action="'.$url.'">';
        foreach ($params as $key => $value) {
            echo '<input type="hidden" name="'.$key.'" value="'.$value.'">';
        }
        echo '<input type="submit" id="send" value="Send">';
        echo '</form>';
        echo '</body>';
        echo '</html>';
    }

    public function executePostCurl($url, $params)
    {
        //Mage::log(sprintf("SAML executePostCurl: url: %s, params: %s", $url, json_encode($params)));
        $ch = curl_init();
        curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
        curl_setopt($ch,CURLOPT_URL, $url);
        curl_setopt($ch,CURLOPT_POST,true);
        curl_setopt($ch,CURLOPT_POSTFIELDS, http_build_query($params));
        $result = curl_exec($ch);
    }

    public function createAuthNrequestXML($settingsInfo)
    {
        $settings = new OneLogin_Saml2_Settings($settingsInfo, true);
        $authNRequest = new OneLogin_Saml2_AuthnRequest($settings);
        $authNRequestXML = $authNRequest->getXML();

        if (isset($_GET['idp']) && !empty($_GET['idp'])) {
            $idp = urldecode(base64_decode($_GET['idp']));
            $scope = <<<SCOPE
<samlp:Scoping>
  <samlp:IDPList>
     <samlp:IDPEntry ProviderID="{$idp}" Name="string"/>
  </samlp:IDPList>
</samlp:Scoping>
</samlp:AuthnRequest>
SCOPE;
            $authNRequestXML = str_replace("</samlp:AuthnRequest>", $scope, $authNRequestXML);
        }
        return $authNRequestXML;
    }

    public function deflateAndEncode($request)
    {
        $deflatedRequest = gzdeflate($request);
        $base64Request = base64_encode($deflatedRequest);
        return $base64Request;
    }
}
