<?php

class Onelogin_SAML_Helper_Data extends Mage_Core_Helper_Abstract
{
    protected static $BENIFY_SSO_PARAMS = [
        "city",
        "countryCode",
        "email",
        "employeeNumber",
        "firstName",
        "lastName",
        "mobileNumberPrivate",
        "mobileNumberWork",
        "organisationalNumber",
        "street",
        "userIdentifier",
        "zipCode",

        "redirectUrl",
        "returnUrl",
    ];

    /**
     * Get config data by key
     *
     * @param string $key
     * @return mixed
     */
    public function getConfig($key = '')
    {
        return Mage::getStoreConfig($key);
    }

    /**
     * Get if module is enabled
     *
     * @return bool
     */
    public function checkEnabledModule()
    {
        return Mage::getStoreConfig('onelogin_saml/status/enabled');
    }

    /**
     * Get Settings
     *
     * @return Array
     */
    public function getSettings()
    {
        try {
            require(dirname(dirname(__FILE__)) . '/settings.php');
            return $settings;
        } catch (Exception $e) {
            $this->_processError('There is a problem with the SAML settings.' . $e->getMessage() . '<br>Review System > Configuration > Services > SAML.');
        }
    }

    /**
     * Get saml auth
     *
     * @return OneLogin_SAML_Auth
     */
    public function getAuth()
    {
        try {
            require(dirname(dirname(__FILE__)) . '/settings.php');
            $auth = new OneLogin_Saml2_Auth($settings);
            return $auth;
        } catch (Exception $e) {
            $this->_processError('There is a problem with the SAML settings.' . $e->getMessage() . '<br>Review System > Configuration > Services > SAML.');
        }
    }

    /**
     * Process SAML Response
     *
     */
    public function processSSO()
    {
        if (Mage::helper('onelogin_saml')->checkEnabledModule()) {
            $auth = Mage::helper('onelogin_saml')->getAuth();
            $auth->processResponse();
            $errors = $auth->getErrors();

            if (!empty($errors)) {
                $error_msg = 'Error at the ACS Endpoint.<br>' . implode(', ', $errors);
                $reason = $auth->getLastErrorReason();

                // Send admin error email
                $error_msg = "Error at the ACS Endpoint.\n" . implode(', ', $errors);
                if (isset($reason) && !empty($reason)) {
                    $error_msg .= "\n\nReason: " . $reason;
                }

                // Dont send email if user click back in browser etc.
                if (strpos($reason, "AuthnFailed") == false) {
                    $this->_processAdminError($error_msg);
                }
                //

                if (Mage::getStoreConfig('onelogin_saml/advanced/debug')) {
                    if (isset($reason) && !empty($reason)) {
                        $error_msg .= '<br><br>Reason: ' . $reason;
                    }
                }
                $this->_processError($error_msg);

                Mage::app()->getFrontController()->getResponse()->setRedirect(Mage::getBaseUrl())->sendResponse();
            } else if (!$auth->isAuthenticated()) {
                $this->_processError('ACS Process failed');
                Mage::app()->getFrontController()->getResponse()->setRedirect(Mage::getBaseUrl())->sendResponse();
            } else {
                $data = $auth->getAttributes();

                foreach(self::$BENIFY_SSO_PARAMS as $k) {
                    if(empty($data[$k])) {
                        $data[$k] = "";
                    }
                    else if(is_array($data[$k])) {
                        $data[$k] = implode("", $data[$k]);
                    }
                }

                $customer = Mage::helper('benifybio')->fetchCustomer($data, Mage::app()->getWebsite()->getId());

                Mage::log(sprintf("SAML Login Success: UserId: %d, Data: %s", $customer->getId(), json_encode($data)), Zend_Log::DEBUG, "onelogin_saml");

                $customerSession = Mage::getSingleton('customer/session');

                $customerSession->loginById($customer->getId());
                $customerSession->setData('saml_login', true);
                $customerSession->setData('saml_nameid', $auth->getNameId());
                $customerSession->setData('saml_sessionindex', $auth->getSessionIndex());

                if (empty($data["redirectUrl"])) {
                    $relayState = Mage::app()->getFrontController()->getRequest()->getPost('RelayState');
                    if (!empty($relayState)) {
                        $urlToGo = $relayState;
                    } else {
                        $urlToGo = Mage::getBaseUrl();
                    }

                    Mage::app()->getFrontController()->getResponse()->setRedirect($urlToGo)->sendResponse();
                } else {
                    header("Location: " . Mage::getBaseUrl() . trim($data["redirectUrl"], "/"));
                }
            }
        } else {
            $this->_processError('Onelogin SAML module has disabled status');
        }
    }

    public function initSLO()
    {
        $customerSession = Mage::getSingleton('customer/session');
        if ($customerSession->isLoggedIn()) {
            $saml_login = $customerSession->getData('saml_login');
            if ($saml_login) {
                $auth = $this->getAuth();
                $samlSessionindex = $customerSession->getData('saml_sessionindex');
                $samlNameId = $customerSession->getData('saml_nameid');
                if (!empty($samlSessionindex)) {
                    $auth->logout(Mage::getBaseUrl(), array(), $samlNameId, $samlSessionindex);
                } else {
                    $auth->logout(Mage::getBaseUrl(), array(), $samlNameId);
                }
            }
        }
    }

    /**
     * Process SLO
     *
     */
    public function processSLO()
    {
        if (Mage::helper('onelogin_saml')->checkEnabledModule()) {
            $auth = Mage::helper('onelogin_saml')->getAuth();
            $auth->processSLO();
            $errors = $auth->getErrors();
            if (empty($errors)) {
                // local logout
                $customerSession = Mage::getSingleton('customer/session');
                $customerSession->unsetData('saml_login');
                $customerSession->logout();
                Mage::app()->getFrontController()->getResponse()->setRedirect(Mage::getBaseUrl())->sendResponse();
                // If there is a duplicate header problem, use instead
                // header ('HTTP/1.1 301 Moved Permanently');
                // header ('Location: ' . Mage::getBaseUrl());
                // exit;
            } else {
                $error_msg = 'Error at the SLS Endpoint.<br>' . implode(', ', $errors);
                if (Mage::getStoreConfig('onelogin_saml/advanced/debug')) {
                    $reason = $auth->getLastErrorReason();
                    if (isset($reason) && !empty($reason)) {
                        $error_msg .= '<br><br>Reason: ' . $reason;
                    }
                }
                $this->_processError($error_msg);
            }
        } else {
            $this->_processError('Onelogin SAML module has disabled status');
        }
    }

    public function printSPMetadata()
    {
        try {
            $settingsInfo = $this->getSettings();
            $settings = new OneLogin_Saml2_Settings($settingsInfo, true);
            $metadata = $settings->getSPMetadata();
            $errors = $settings->validateMetadata($metadata);
            if (empty($errors)) {
                header('Content-Type: text/xml');
                header('SAML-Magento: 1.1.1');
                echo $metadata;
                exit();
            } else {
                throw new OneLogin_Saml2_Error(
                'Invalid SP metadata: ' . implode(', ', $errors), OneLogin_Saml2_Error::METADATA_SP_INVALID
                );
            }
        } catch (Exception $e) {
            echo $e->getMessage();
        }
    }

    public function _processError($errorMsg)
    {
        Mage::log($errorMsg, Zend_Log::ERR, "onelogin_saml");

        Mage::getSingleton('core/session')->addError($errorMsg);
        Mage::app()->getFrontController()->getResponse()->setRedirect(Mage::getBaseUrl())->sendResponse();
        exit();
    }

    public function _processAdminError($msg = "")
    {
        Mage::log($msg, Zend_Log::ERR, "onelogin_saml");

        $msg .= "\n\nGET: " . print_r($_GET, true);
        $msg .= "\n\nPOST: " . print_r($_POST, true);
        $msg .= "\n\nSERVER: " . print_r($_SERVER, true);

        @mail('it@crossroads.se', 'Benifydeals SAML error', $msg);
    }

}
