SAML Single Sign On Extension by Sixto Martin
=============================================

Description
-----------

Magento extension that add SAML Single Sign On support to the customer login page. 


If you are working with a partner that has implemented a SAML identity provider, you can use this extension to interoperate with it, thereby enabling SSO for customers. It works with any IDP providers, including OneLogin, Okta, Ping Identity, ADFS, Salesforce, SharePoint...

The module is tested on Magento CE 1.7+ and Magento EE 1.12+

The module was implemented by [Sixto Martin](http://pitbulk.github.io) , author of 15+ SAML plugins and several SAML toolkits.

If you want to enable SAML Single Sign On for your admins, there is an specific extension.



Features
--------

* Supports Single Sign On (IdP and SP initiated)
* Supports Single Log Out (IdP and SP initiated)
* Supports Just-In-Time Provisioning (user data + group + address)
* Customizable workflow.


How does it work?
-----------------

The normal usage
................

Extension adds a link "Login via Identity provider" at the customer login form. 
Following this links initiates series of redirects that are described by [SAML 2.0 standart](http://en.wikipedia.org/wiki/SAML_2.0)

User authenticates against the SAML Identity Provider and then information about user, group and address is sent to Magento. Magento authenticate user and let him in.


Other usages
............

Extension supports IdP-Initiated so a SAML Response can be directly processed by the Magento instance.


Installation
------------

Install the package using Magento Connect. After install the package you will need to sign-out and sign-in 
from the Admin interface in order to enable the SAML Setting section (If not you will get a 404 error).

Settings
--------

The Settings of the extension are available at System > Configuration. At the Services tab, the "SAML" link.

There you will be able to fill several sections:

 * Status. To enable or disable the extension. 
 * Identity Provider. Set parameters related to the IdP that will be connected with our Magento.
 * Options. The behavior of the extension. 
 * Attribute Mapping. Set the mapping between IdP fields and Magento user fields.
 * Group Mapping. Set the mapping between IdP groups and Magento groups.
 * Address Mapping. Set the mapping between IdP fields and Magento address fields.
 * Custom messages. To handle what messages are showed in the login form 
 * Advanced settings. Handle some other parameters related to customizations and security issues.


The metadata of the Magento Service Provider will be available at http://<magento_base_url>/sso/saml/metadata


Warranty
--------

Support by mail <sixto.martin.garcia@gmail.com> guaranteed. Get a reply in less than 48h (business day).


Magento versions support
------------------------

Compatible with Magento CE 1.7+, Magento EE 1.12+
