# Klarna XMLRPC PHP SDK
[![Packagist Version][packagist-image]](https://packagist.org/packages/klarna/php-xmlrpc)

## About Klarna
Klarna was founded in Stockholm in 2005 with the idea of providing a
zero-friction online payment solution that would allow consumers and merchants
to interact with each other as safely and simply as possible. We do this by
letting the consumer receive the goods first and pay afterwards, while we assume
the credit and fraud risks for the merchants. Today, Klarna is one of Europe's
fastest growing companies. In just 8 years, we've grown to 800 employees
operating in 7 European countries with over 8 million consumers. But we are not
satisfied with that. Our goal is to become market leaders within invoice-based
payments worldwide and change the way the world shops online.


## Get started

### Prerequisites
* PHP 5.4.0 or above
* API credentials


### Usage
Example files can be found in the [docs/](docs/) directory.


## Documentation
Documentation and more examples can be found at
[developers.klarna.com](https://developers.klarna.com).

## Upgrading
If you are upgrading from version 4 or earlier you can read more about it in [docs/UPGRADE_v5.md](docs/UPGRADE_v5.md)

## Questions and feedback
If you have any questions concerning this product or the implementation,
please contact [integration@klarna.com](mailto:integration@klarna.com).


## How to contribute
At Klarna, we strive toward achieving the highest possible quality for our
products. Therefore, we require you to follow these guidelines if you wish
to contribute.

To contribute, the following criteria needs to be fulfilled:

* Description regarding what has been changed and why
* Pull requests should implement a boxed change
* All code and documentation must follow the
[PEAR coding standards](http://pear.php.net/manual/en/standards.php)
* All classes must follow the [PSR-0 standard](https://github.com/php-fig/fig-standards/blob/master/accepted/PSR-0.md)


## License
The Klarna XMLRPC PHP SDK is released under [Apache License, Version 2.0](http://www.apache.org/LICENSE-2.0)

[packagist-image]: https://img.shields.io/packagist/v/klarna/php-xmlrpc.svg?style=flat
