<?php

declare(strict_types=1);

namespace Crossroads\Magento\Test\Integration\Config;

use Mage;
use Mage_Core_Model_Config_Options;

class Options extends Mage_Core_Model_Config_Options {
    protected function _construct() {
        $appRoot= Mage::getRoot();
        $root   = dirname($appRoot);

        $this->_data['app_dir']     = $appRoot;
        $this->_data['base_dir']    = $root;
        $this->_data['code_dir']    = $appRoot.DS.'code';
        $this->_data['design_dir']  = $appRoot.DS.'design';
        $this->_data['etc_dir']     = $appRoot.DS.'etc';
        $this->_data['lib_dir']     = $root.DS.'lib';
        $this->_data['locale_dir']  = $appRoot.DS.'locale';
        $this->_data['media_dir']   = $root.DS.'media';
        $this->_data['skin_dir']    = $root.DS.'skin';
        $this->_data["var_dir"]     = getcwd().DS."var";
        $this->_data['tmp_dir']     = $this->_data['var_dir'].DS.'tmp';
        $this->_data['cache_dir']   = $this->_data['var_dir'].DS.'cache';
        $this->_data['log_dir']     = $this->_data['var_dir'].DS.'log';
        $this->_data['session_dir'] = $this->_data['var_dir'].DS.'session';
        $this->_data['upload_dir']  = $this->_data['media_dir'].DS.'upload';
        $this->_data['export_dir']  = $this->_data['var_dir'].DS.'export';
    }

    public function getVarDir()
    {
        $dir = $this->_data["var_dir"];

        if( ! $this->createDirIfNotExists($dir)) {
            throw new Mage_Core_Exception('Unable to find writable var_dir');
        }

        return $dir;
    }
}
