<?php

declare(strict_types=1);

use Crossroads\Magento\Test\Unit\TestCase;
use Crossroads\Magento\Test\Unit\Mock\App;

/**
 * @covers Crossroads\Magento\Test\Unit\Mock\Mage
 */
class MageTest extends TestCase {
    /**
     * @covers Crossroads\Magento\Test\Unit\Mock\Mage::helper
     */
    public function testHelperEmpty() {
        $this->expectException(RuntimeException::class);

        Mage::helper("test");
    }

    /**
     * @covers Crossroads\Magento\Test\Unit\Mock\Mage::helper
     * @covers Crossroads\Magento\Test\Unit\Mock\Mage::_setHelper
     */
    public function testHelper() {
        $h = new stdClass;

        Mage::_setHelper("test", $h);

        $this->assertSame(Mage::helper("test"), $h);
    }

    /**
     * @covers Crossroads\Magento\Test\Unit\Mock\Mage::helper
     * @covers Crossroads\Magento\Test\Unit\Mock\Mage::_setHelper
     */
    public function testHelperCallable() {
        $h = new stdClass;

        Mage::_setHelper("test", function() use($h) {
            $this->assertEquals([], func_get_args());

            return $h;
        });

        $this->assertSame($h, Mage::helper("test"));
    }

    /**
     * @covers Crossroads\Magento\Test\Unit\Mock\Mage::getModel
     */
    public function testGetModelEmpty() {
        $this->expectException(RuntimeException::class);

        Mage::getModel("test");
    }

    /**
     * @covers Crossroads\Magento\Test\Unit\Mock\Mage::getModel
     * @covers Crossroads\Magento\Test\Unit\Mock\Mage::_setModel
     */
    public function testGetModel() {
        $h = new stdClass;

        Mage::_setModel("test", $h);

        $this->assertSame(Mage::getModel("test"), $h);
    }

    /**
     * @covers Crossroads\Magento\Test\Unit\Mock\Mage::getModel
     * @covers Crossroads\Magento\Test\Unit\Mock\Mage::_setModel
     */
    public function testGetModelCallable() {
        $h = new stdClass;

        Mage::_setModel("test", function() use($h) {
            $this->assertEquals([[]], func_get_args());

            return $h;
        });

        $this->assertSame($h, Mage::getModel("test"));
    }

    /**
     * @covers Crossroads\Magento\Test\Unit\Mock\Mage::getModel
     * @covers Crossroads\Magento\Test\Unit\Mock\Mage::_setModel
     */
    public function testGetModelCallable2() {
        $h = new stdClass;
        $a = new stdClass;

        Mage::_setModel("test", function() use($h, $a) {
            $this->assertEquals([[ "foo" => $a ]], func_get_args());

            return $h;
        });

        $this->assertSame($h, Mage::getModel("test", [ "foo" => $a ]));
    }

    /**
     * @covers Crossroads\Magento\Test\Unit\Mock\Mage::getSingleton
     */
    public function testGetSingletonEmpty() {
        $this->expectException(RuntimeException::class);

        Mage::getSingleton("test");
    }

    /**
     * @covers Crossroads\Magento\Test\Unit\Mock\Mage::getSingleton
     * @covers Crossroads\Magento\Test\Unit\Mock\Mage::_setSingleton
     */
    public function testGetSingleton() {
        $h = new stdClass;

        Mage::_setSingleton("test", $h);

        $this->assertSame(Mage::getSingleton("test"), $h);
    }

    /**
     * @covers Crossroads\Magento\Test\Unit\Mock\Mage::getSingleton
     * @covers Crossroads\Magento\Test\Unit\Mock\Mage::_setSingleton
     */
    public function testGetSingletonCallable() {
        $h = new stdClass;

        Mage::_setSingleton("test", function() use($h) {
            $this->assertEquals([[]], func_get_args());

            return $h;
        });

        $this->assertSame($h, Mage::getSingleton("test"));
    }

    /**
     * @covers Crossroads\Magento\Test\Unit\Mock\Mage::getSingleton
     * @covers Crossroads\Magento\Test\Unit\Mock\Mage::_setSingleton
     */
    public function testGetSingletonCallable2() {
        $h = new stdClass;
        $a = new stdClass;

        Mage::_setSingleton("test", function() use($h, $a) {
            $this->assertEquals([[ "foo" => $a ]], func_get_args());

            return $h;
        });

        $this->assertSame($h, Mage::getSingleton("test", [ "foo" => $a ]));
    }

    /**
     * @covers Crossroads\Magento\Test\Unit\Mock\Mage::getResourceSingleton
     */
    public function testGetResourceSingletonEmpty() {
        $this->expectException(RuntimeException::class);

        Mage::getResourceSingleton("test");
    }

    /**
     * @covers Crossroads\Magento\Test\Unit\Mock\Mage::getResourceSingleton
     * @covers Crossroads\Magento\Test\Unit\Mock\Mage::_setResourceSingleton
     */
    public function testGetResourceSingleton() {
        $h = new stdClass;

        Mage::_setResourceSingleton("test", $h);

        $this->assertSame(Mage::getResourceSingleton("test"), $h);
    }

    /**
     * @covers Crossroads\Magento\Test\Unit\Mock\Mage::getResourceSingleton
     * @covers Crossroads\Magento\Test\Unit\Mock\Mage::_setResourceSingleton
     */
    public function testGetResourceSingletonCallable() {
        $h = new stdClass;

        Mage::_setResourceSingleton("test", function() use($h) {
            $this->assertEquals([[]], func_get_args());

            return $h;
        });

        $this->assertSame($h, Mage::getResourceSingleton("test"));
    }

    /**
     * @covers Crossroads\Magento\Test\Unit\Mock\Mage::getResourceSingleton
     * @covers Crossroads\Magento\Test\Unit\Mock\Mage::_setResourceSingleton
     */
    public function testGetResourceSingletonCallable2() {
        $h = new stdClass;
        $a = new stdClass;

        Mage::_setResourceSingleton("test", function() use($h, $a) {
            $this->assertEquals([[ "foo" => $a ]], func_get_args());

            return $h;
        });

        $this->assertSame($h, Mage::getResourceSingleton("test", [ "foo" => $a ]));
    }

    /**
     * @covers Crossroads\Magento\Test\Unit\Mock\Mage::dispatchEvent
     */
    public function testDispatchEventEmpty() {
        $this->expectException(RuntimeException::class);

        Mage::dispatchEvent("test", []);
    }

    /**
     * @covers Crossroads\Magento\Test\Unit\Mock\Mage::dispatchEvent
     * @covers Crossroads\Magento\Test\Unit\Mock\Mage::_setEventListener
     */
    public function testDispatchEvent() {
        $value = null;

        Mage::_setEventListener("test", function($v) use(&$value) {
            $value = $v;

            return "whatevs";
        });

        $this->assertSame(null, Mage::dispatchEvent("test", []));
        $this->assertSame([], $value);
    }

    /**
     * @covers Crossroads\Magento\Test\Unit\Mock\Mage::dispatchEvent
     * @covers Crossroads\Magento\Test\Unit\Mock\Mage::_setEventListener
     */
    public function testDispatchEvent2() {
        $value = null;
        $obj   = new stdClass;

        Mage::_setEventListener("test", function($v) use(&$value) {
            $value = $v;

            return "whatevs";
        });

        $this->assertSame(null, Mage::dispatchEvent("test", [ "a" => $obj ]));
        $this->assertSame([ "a" => $obj ], $value);
    }

    /**
     * @covers Crossroads\Magento\Test\Unit\Mock\Mage::reset
     */
    public function testReset() {
        $this->expectException(RuntimeException::class);

        Mage::_setEventListener("test", function() {});
        Mage::reset();
        Mage::dispatchEvent("test", []);
    }

    /**
     * @covers Crossroads\Magento\Test\Unit\Mock\Mage::reset
     */
    public function testClear2() {
        $this->expectException(RuntimeException::class);

        Mage::_setModel("test", "foo");
        Mage::reset();
        Mage::getModel("test");
    }

    /**
     * @covers Crossroads\Magento\Test\Unit\Mock\Mage::reset
     */
    public function testClear3() {
        $this->expectException(RuntimeException::class);

        Mage::_setHelper("test", "foo");
        Mage::reset();
        Mage::helper("test");
    }

    /**
     * @covers Crossroads\Magento\Test\Unit\Mock\Mage::reset
     */
    public function testClear4() {
        $this->expectException(RuntimeException::class);

        Mage::_setSingleton("test", "foo");
        Mage::reset();
        Mage::getSingleton("test", []);
    }

    /**
     * @covers Crossroads\Magento\Test\Unit\Mock\Mage::reset
     */
    public function testClear5() {
        $this->expectException(RuntimeException::class);

        Mage::_setResourceSingleton("test", "foo");
        Mage::reset();
        Mage::getResourceSingleton("test", []);
    }

    /**
     * @covers Crossroads\Magento\Test\Unit\Mock\Mage::reset
     */
    public function testClear6() {
        $this->expectException(RuntimeException::class);

        Mage::_initConfig([]);
        Mage::reset();
        Mage::app();
    }

    /**
     * @covers Crossroads\Magento\Test\Unit\Mock\Mage::app
     */
    public function testAppEmpty() {
        $this->expectException(RuntimeException::class);

        Mage::app();
    }

    /**
     * @covers Crossroads\Magento\Test\Unit\Mock\Mage::app
     */
    public function testApp() {
        Mage::_initConfig([]);
        $this->assertInstanceOf(App::class, Mage::app());
    }
}
