<?php
/**
 * Magento
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@magento.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to http://www.magento.com for more information.
 *
 * @category    Magento
 * @package     Magento_Profiler
 * @copyright  Copyright (c) 2006-2019 Magento, Inc. (http://www.magento.com)
 * @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 */

/**
 * Class that represents profiler output in Html format
 */
class Magento_Profiler_Output_Html extends Magento_Profiler_OutputAbstract
{
    /**
     * Display profiling results
     */
    public function display()
    {
        $out  = '<table border="1" cellspacing="0" cellpadding="2">';
        $out .= '<caption>' . $this->_renderCaption() . '</caption>';
        $out .= '<tr>';
        foreach (array_keys($this->_getColumns()) as $columnLabel) {
            $out .= '<th>' . $columnLabel . '</th>';
        }
        $out .= '</tr>';
        foreach ($this->_getTimers() as $timerId) {
            $out .= '<tr>';
            foreach ($this->_getColumns() as $columnId) {
                $out .= '<td title="' . $timerId . '">' . $this->_renderColumnValue($timerId, $columnId) . '</td>';
            }
            $out .= '</tr>';
        }
        $out .= '</table>';

        echo $out;
    }

    /**
     * Render timer id column value
     *
     * @param string $timerId
     * @return string
     */
    protected function _renderTimerId($timerId)
    {
        $nestingSep = preg_quote(Magento_Profiler::NESTING_SEPARATOR, '/');
        return preg_replace('/.+?' . $nestingSep . '/', '&middot;&nbsp;&nbsp;', $timerId);
    }
}
