<?php

class Crossroads_Stripe_Helper_Config extends Mage_Core_Helper_Abstract
{
    const ACTIVE = 'payment/Crossroads_Stripe_PaymentIntents/active';
    const TITLE = 'payment/Crossroads_Stripe_PaymentIntents/title';
    const PUBLISHABLE_KEY = 'payment/Crossroads_Stripe_PaymentIntents/publishable_key';
    const SECRET_KEY = 'payment/Crossroads_Stripe_PaymentIntents/secret_key';
    const ORDER_STATUS = 'payment/Crossroads_Stripe_PaymentIntents/order_status';
    const MIN_ORDER_TOTAL = 'payment/Crossroads_Stripe_PaymentIntents/min_order_total';

    /**
     * @return bool
     */
    public function active(Mage_Core_Model_Store $store)
    {
        return 1 === (int) $store->getConfig(self::ACTIVE);
    }

    /**
     * @return string
     */
    public function title(Mage_Core_Model_Store $store)
    {
        return (string) $store->getConfig(self::TITLE);
    }

    /**
     * @return string
     */
    public function publishableKey(Mage_Core_Model_Store $store)
    {
        return (string) $store->getConfig(self::PUBLISHABLE_KEY);
    }

    /**
     * @return string
     */
    public function secretKey(Mage_Core_Model_Store $store)
    {
        return (string) $store->getConfig(self::SECRET_KEY);
    }

    /**
     * @return string
     */
    public function orderStatus(Mage_Core_Model_Store $store)
    {
        return (string) $store->getConfig(self::ORDER_STATUS);
    }

    /**
     * @return float
     */
    public function minOrderTotal(Mage_Core_Model_Store $store)
    {
        return (float) $store->getConfig(self::MIN_ORDER_TOTAL);
    }

    /**
     * @return bool
     */
    public function sftpExportActive()
    {
        return 1 === (int) Mage::getStoreConfig('payment/Crossroads_Stripe_PaymentIntents/sftp_export_active');
    }

    /**
     * @return string
     */
    public function sftpExportHost()
    {
        return (string) Mage::getStoreConfig('payment/Crossroads_Stripe_PaymentIntents/sftp_export_host');
    }

    /**
     * @return string
     */
    public function sftpExportPath()
    {
        return (string) Mage::getStoreConfig('payment/Crossroads_Stripe_PaymentIntents/sftp_export_path');
    }

    /**
     * @return string
     */
    public function sftpExportUsername()
    {
        return (string) Mage::getStoreConfig('payment/Crossroads_Stripe_PaymentIntents/sftp_export_username');
    }

    /**
     * @return string
     */
    public function sftpExportPassword()
    {
        return (string) Mage::getStoreConfig('payment/Crossroads_Stripe_PaymentIntents/sftp_export_password');
    }

    /**
     * @return string
     */
    public function sftpExportPort()
    {
        return (string) Mage::getStoreConfig('payment/Crossroads_Stripe_PaymentIntents/sftp_export_port') ?: '22';
    }
}
