<?php

class Crossroads_Stripe_Model_Export_Sftp
{
    /**
     * @return bool
     */
    public function isEnabled()
    {
        return $this->config()->sftpExportActive();
    }

    /**
     * @return Crossroads_Stripe_Helper_Config
     */
    public function config()
    {
        return Mage::helper('Crossroads_Stripe/config');
    }

    /**
     * @param string $filename
     * @param string $dataFile
     * @throws Mage_Core_Exception
     */
    public function uploadOrderCsv($filename, $dataFile)
    {
        $sftpServer = $this->config()->sftpExportHost();
        $sftpUsername = $this->config()->sftpExportUsername();
        $sftpPassword = $this->config()->sftpExportPassword();
        $sftpPort = $this->config()->sftpExportPort();
        $sftpRemoteDir = $this->config()->sftpExportPath();

        $ch = curl_init('sftp://'.$sftpServer.':'.$sftpPort.$sftpRemoteDir.'/'.$filename);

        $fh = fopen($dataFile, 'r');

        if (!$fh) {
            Mage::throwException('Unable to read local csv file');
        }

        curl_setopt($ch, CURLOPT_USERPWD, $sftpUsername.':'.$sftpPassword);
        curl_setopt($ch, CURLOPT_UPLOAD, true);
        curl_setopt($ch, CURLOPT_PROTOCOLS, CURLPROTO_SFTP);
        curl_setopt($ch, CURLOPT_INFILE, $fh);
        curl_setopt($ch, CURLOPT_INFILESIZE, filesize($dataFile));
        curl_setopt($ch, CURLOPT_VERBOSE, true);
        curl_setopt($ch, CURLOPT_FTP_CREATE_MISSING_DIRS, true);

        $verbose = fopen('php://temp', 'w+');
        curl_setopt($ch, CURLOPT_STDERR, $verbose);

        $response = curl_exec($ch);
        $error = curl_error($ch);
        curl_close($ch);

        if (!$response) {
            rewind($verbose);
            $verboseLog = stream_get_contents($verbose);
            Mage::log($verboseLog, Zend_Log::ERR);
            Mage::log($error, Zend_Log::ERR);

            Mage::throwException('Unable to create file on sftp');
        }
    }
}
