Crossroads API - Stripe payments
================================

## Stripe Docs

* [Payment intents](https://stripe.com/docs/payments/payment-intents)
* [Payment request button](https://stripe.com/docs/stripe-js/elements/payment-request-button)

## Composer.json

Add the following to your `composer.json`:

```
{
	"name": "Your project name",
	"description": "Your project description",
	"require": {
		"crossroads/stripe": "dev-master",
		"magento-hackathon/magento-composer-installer": "*"
	},
	"repositories": [
		{
			"type": "vcs",
			"url":  "git@groot.crossroads.se:modules/stripe.git"
		}
	],
	"extra": {
		"magento-root-dir":      ".",
		"auto-append-gitignore": true
	}
}
```

## API

This module introduces the following to the `Crossroads-API` module:

* `/api/checkout` will add the key `paymentMethodData` when `Crossroads_Stripe_PaymentIntents` is selected
  containing the `publishableKey`
  
  This key is used by the stripe javascript library (see stripe docs)

* `/api/payment/Crossroads_Stripe_PaymentIntents/confirmPayment`

  post the results from stripe here.

   
## Checkout flow

1. `PUT /api/checkout` with `paymentMethod: Crossroads_Stripe_PaymentIntents` and additional required checkout data.

2. Use `paymentMethodData.publishableKey` to create a form and/or payment request button.

3. Optional: request address info from the payment request button

4. Fill out card information or follow the steps with payment request button.

5. Optional: `PUT /checkout` with new address info.

6. Post the result from `/api/payment/Crossroads_Stripe_PaymentIntents/confirmPayment`

7. If response from confirmPayment has `responseBody.requires_action: true`
   then call run `stripe.handleCardAction(responseBody.payment_intent_client_secret)`
   and send the response once again to /api/payment/Crossroads_Stripe_PaymentIntents/confirmPayment

8. The intent has now been created and linked to the quote.
   `POST /api/checkout` to create the order.

9. If payment module config is set the authorize and capture then the payment will be capture on checkout.
   If not, then the payment will be captured when a user creates an invoice in the admin.
