<?php

class Crossroads_Stripe_Model_Observer_IntegrationExportCronJob
{
    const INTEGRATIONS_TABLE = 'crossroads_integration_orders';

    public function run()
    {
        $ordersModel = Mage::getModel('Crossroads_Stripe/export_orders');
        $csvModel = Mage::getModel('Crossroads_Stripe/export_csv');
        $sftpModel = Mage::getModel('Crossroads_Stripe/export_sftp');

        if (!$sftpModel->isEnabled()) {
            return; // skip
        }

        if (!$ordersModel->integrationTableExists()) {
            return; // skip
        }

        $collection = $ordersModel->getOrdersForExport();

        if (0 === $collection->count()) {
            return; // skip
        }

        $ordersModel->setStatusesToProcessing($collection);

        try {
            $localFile = $csvModel->generate($collection);

            $filename = date('Y-m-d_H-i-s').'.csv';

            $sftpModel->uploadOrderCsv($filename, $localFile);

            $ordersModel->setStatusesToExported($collection);
        } catch (Exception $e) {
            $ordersModel->setStatusesToFailed($collection);

            Mage::logException($e);
        }
    }
}
