<?php

class Crossroads_Stripe_Model_Observer_CheckoutObserver
{
    /**
     * @param Varien_Event_Observer $observer
     * @throws Exception
     */
    public function preMerge(Varien_Event_Observer $observer)
    {
        /** @var Mage_Sales_Model_Quote $quote */
        $quote = $observer->getEvent()->getData('quote');

        $method = Mage::getModel('Crossroads_Stripe/payment_paymentIntents')->getCode();

        if ($method !== $quote->getPayment()->getMethod()) {
            return;
        }

        $intent = $this->intentHelper()->getPaymentIntentFromPayment($quote->getPayment());

        if (!$intent) {
            return;
        }

        if ($this->intentHelper()->hasSameTotal($quote->getPayment(), $intent)) {
            return;
        }

        try {
            $intent->cancel();
            $this->intentHelper()->removePaymentIntentFromPayment($quote->getPayment());
        } catch (\Stripe\Error\Base $e) {
            throw Crossroads_API_ResponseException::create(500, $e->getMessage());
        }
    }

    /**
     * @return Crossroads_Stripe_Helper_Config
     */
    protected function config()
    {
        return Mage::helper('Crossroads_Stripe/config');
    }

    /**
     * @return Crossroads_Stripe_Helper_Intent
     */
    protected function intentHelper()
    {
        return Mage::helper('Crossroads_Stripe/intent');
    }
}
