<?php

class Crossroads_Stripe_Helper_Config extends Mage_Core_Helper_Abstract
{
    /**
     * @return bool
     */
    public function active()
    {
        return 1 === (int) Mage::getStoreConfig('payment/Crossroads_Stripe_PaymentIntents/active');
    }

    /**
     * @return string
     */
    public function title()
    {
        return (string) Mage::getStoreConfig('payment/Crossroads_Stripe_PaymentIntents/title');
    }

    /**
     * @return string
     */
    public function publishableKey()
    {
        return (string) Mage::getStoreConfig('payment/Crossroads_Stripe_PaymentIntents/publishable_key');
    }

    /**
     * @return string
     */
    public function secretKey()
    {
        return (string) Mage::getStoreConfig('payment/Crossroads_Stripe_PaymentIntents/secret_key');
    }

    /**
     * @return string
     */
    public function orderStatus()
    {
        return (string) Mage::getStoreConfig('payment/Crossroads_Stripe_PaymentIntents/order_status');
    }

    /**
     * @return float
     */
    public function minOrderTotal()
    {
        return (float) Mage::getStoreConfig('payment/Crossroads_Stripe_PaymentIntents/min_order_total');
    }

    /**
     * @return bool
     */
    public function sftpExportActive()
    {
        return 1 === (int) Mage::getStoreConfig('payment/Crossroads_Stripe_PaymentIntents/sftp_export_active');
    }

    /**
     * @return string
     */
    public function sftpExportHost()
    {
        return (string) Mage::getStoreConfig('payment/Crossroads_Stripe_PaymentIntents/sftp_export_host');
    }

    /**
     * @return string
     */
    public function sftpExportPath()
    {
        return (string) Mage::getStoreConfig('payment/Crossroads_Stripe_PaymentIntents/sftp_export_path');
    }

    /**
     * @return string
     */
    public function sftpExportUsername()
    {
        return (string) Mage::getStoreConfig('payment/Crossroads_Stripe_PaymentIntents/sftp_export_username');
    }

    /**
     * @return string
     */
    public function sftpExportPassword()
    {
        return (string) Mage::getStoreConfig('payment/Crossroads_Stripe_PaymentIntents/sftp_export_password');
    }

    /**
     * @return string
     */
    public function sftpExportPort()
    {
        return (string) Mage::getStoreConfig('payment/Crossroads_Stripe_PaymentIntents/sftp_export_port') ?: '22';
    }
}
