<?php

class Crossroads_Stripe_Model_Payment_PaymentIntents extends Crossroads_API_Payment_Abstract
{
    /**
     * @return string
     */
    public function getCode()
    {
        return 'Crossroads_Stripe_PaymentIntents';
    }

    /**
     * @return string|null
     */
    public function getControllerClassName()
    {
        return 'Crossroads_Stripe_Controller_Payment';
    }

    /**
     * @param Mage_Sales_Model_Quote $quote
     * @return array|null
     */
    public function getPaymentMethodData($quote)
    {
        return [
            'publishableKey' => $this->config()->publishableKey(),
        ];
    }

    /**
     * @param Mage_Sales_Model_Quote $_quote
     * @return bool
     */
    public function isQuoteInvalid($_quote)
    {
        return false;
    }

    /**
     * @param Mage_Sales_Model_Quote $_order
     */
    public function getOrderPaymentData($_order)
    {
        return null;
    }

    /**
     * @return Crossroads_Stripe_Helper_Config
     */
    protected function config()
    {
        return Mage::helper('Crossroads_Stripe/config');
    }
}
