<?php

class Crossroads_SMS_Helper_LinkMobility extends Mage_Core_Helper_Abstract
{
    private $post_data;
    private $source = "Crossroads";
    private $sourceTON = "ALPHANUMERIC";
    private $destination = "";
    private $dcs = "TEXT";
    private $userData = "";
    private $refId = "";

    private function buildPostData()
    {
        $this->checkParameters();

        $this->post_data = json_encode([
            "source" => $this->source,
            "sourceTON" => $this->sourceTON,
            "destination" => $this->destination,
            "userData" => $this->userData,
            "platformId" => Mage::getStoreConfig("SMS/LinkMobility/platformid"),
            "platformPartnerId" => Mage::getStoreConfig("SMS/LinkMobility/platform_partnerid"),
            "refId" => $this->refId,
            "dcs" => $this->dcs
        ]);

        return $this;
    }

    private function checkParameters()
    {
        if (empty($this->source)) {
            throw new Exception("Missing parameter: source");
        }

        if (empty($this->sourceTON)) {
            throw new Exception("Missing parameter: sourceTON");
        }

        if (empty($this->destination)) {
            throw new Exception("Missing parameter: destination");
        }

        if (empty($this->dcs)) {
            throw new Exception("Missing parameter: dcs");
        }

        if (empty($this->userData)) {
            throw new Exception("Missing parameter: userData");
        }
    }

    public function setSource($source)
    {
        $this->source = $source;

        return $this;
    }

    public function setSourceTon($sourceTON)
    {
        $this->sourceTON = $sourceTON;

        return $this;
    }

    public function setDestination($destination)
    {
        $this->destination = $destination;

        return $this;
    }

    public function setDCS($dcs)
    {
        $this->dcs = $dcs;

        return $this;
    }

    public function setUserData($userData)
    {
        $this->userData = $userData;

        return $this;
    }

    public function send()
    {
        $this->buildPostData();

        $c = curl_init();
        curl_setopt($c, CURLOPT_URL, Mage::getStoreConfig("SMS/LinkMobility/gateway_url"));
        curl_setopt(
            $c,
            CURLOPT_USERPWD,
            Mage::getStoreConfig("SMS/LinkMobility/username") . ":" . Mage::getStoreConfig("SMS/LinkMobility/password")
        );
        curl_setopt($c, CURLOPT_POST, 1);
        curl_setopt($c, CURLOPT_POSTFIELDS, $this->post_data);
        curl_setopt($c, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($c, CURLOPT_HTTPHEADER, array(
                'Content-Type: application/json',
                'Content-Length: ' . strlen($this->post_data))
        );

        $response = curl_exec($c);

        curl_close($c);

        return $response;
    }
}