<?php

class Crossroads_SkuWatcher_Block_SkuWatcher_Edit extends Mage_Adminhtml_Block_Widget_Form_Container
{
    /** @var Crossroads_SkuWatcher_Helper_Data */
    private $helper;

    /**
     * Constructor for SkuWatcher Edit block.
     */
    public function __construct()
    {
        $this->helper = Mage::helper('crossroads_skuWatcher');

        $this->_blockGroup = 'crossroads_skuWatcher';
        $this->_objectId = 'id';
        $this->_controller = 'skuWatcher';

        parent::__construct();

        $this->_updateButton('save', 'label', $this->helper->__('Save SKU Watcher entry'));
        $this->_updateButton('delete', 'label', $this->helper->__('Delete SKU Watcher entry'));
    }

    /**
     * Get header text.
     * @return string The header.
     */
    public function getHeaderText(): string
    {
        if (Mage::registry('skuWatcher')->exists()) {
            return $this->helper->__('Edit SKU Watcher entry');
        } else {
            return $this->helper->__('New SKU Watcher entry');
        }
    }

    /**
     * Set type.
     * @param string $type.
     * @return self This instance.
     */
    public function setClassType(string $type): self
    {
        $this->getChild('form')->setClassType($type);
        return $this;
    }
}
