<?php

class Crossroads_SkuWatcher_Block_SkuWatcher_Edit_Form extends Mage_Adminhtml_Block_Widget_Form
{
    /** @var Crossroads_SkuWatcher_Helper_Data */
    private $helper;

    /**
     * Constructor for SkuWatcher Form block.
     */
    public function __construct()
    {
        parent::__construct();
        $this->helper = Mage::helper('crossroads_skuWatcher');
        $this->setId('skuWatcherForm');
    }

    /**
     * Field register for SkuWatcher Form block.
     * @return $this
     */
    protected function _prepareForm(): self
    {
        $model = Mage::registry('skuWatcher');

        $form = new Varien_Data_Form([
            'id'        => 'edit_form',
            'action'    => $this->getData('action'),
            'method'    => 'post'
        ]);

        $this->setTitle($this->helper->__('SKU Watcher'));
        $fieldset = $form->addFieldset('base_fieldset', [
            'legend' => $this->helper->__('SKU Watcher entry')
        ]);

        $fieldset->addField('sku', 'text', [
            'name'  => 'sku',
            'label' => $this->helper->__('SKU'),
            'value' => $model->getSku(),
        ]);
        $fieldset->addField('qty', 'text', [
            'name'  => 'qty',
            'label' => $this->helper->__('Quantity'),
            'value' => $model->getQty(),
        ]);
        $fieldset->addField('email', 'text', [
            'name'  => 'email',
            'label' => $this->helper->__('E-mail'),
            'value' => $model->getEmail(),
        ]);
        $fieldset->addField('comment', 'text', [
            'name'  => 'comment',
            'label' => $this->helper->__('Message'),
            'value' => $model->getComment(),
        ]);

        if ($model->exists()) {
            $fieldset->addField('skuWatcher_id', 'hidden', [
                'name'      => 'id',
                'value'     => $model->getId(),
                'no_span'   => true
            ]);
        }

        $form->setAction($this->getUrl('*/*/save'));
        $form->setUseContainer(true);
        $this->setForm($form);

        return parent::_prepareForm();
    }
}
