<?php

class Crossroads_SkuWatcher_Block_SkuWatcher_Grid extends Mage_Adminhtml_Block_Widget_Grid
{
    /**
     * Constructor for SkuWatcher Grid block.
     */
    public function __construct()
    {
        parent::__construct();
        $this->setDefaultSort('created_at');
        $this->setId('skuWatcherGrid');
        $this->setDefaultDir('asc');
        $this->setSaveParametersInSession(true);
    }

    /**
     * Prepare grid collection.
     * @return $this
     */
    protected function _prepareCollection(): self
    {
        $collection = Mage::getModel('crossroads_skuWatcher/skuWatcher')->getCollection();
        $this->setCollection($collection);
        parent::_prepareCollection();
        return $this;
    }

    /**
     * Prepare grid columns.
     * @return $this
     */
    protected function _prepareColumns(): self
    {
        $helper = Mage::helper('awardit_antifraud');

        $this->addColumn('sku', [
            'header' => $helper->__('SKU'),
            'sortable' => true,
            'align' =>'left',
            'index' => 'sku',
        ]);
        $this->addColumn('qty', [
            'header' => $helper->__('Quantity'),
            'sortable' => true,
            'align' =>'left',
            'index' => 'qty',
        ]);
        $this->addColumn('email', [
            'header' => $helper->__('E-mail'),
            'sortable' => true,
            'align' =>'left',
            'index' => 'email',
        ]);
        $this->addColumn('comment', [
            'header' => $helper->__('Message'),
            'sortable' => false,
            'align' =>'left',
            'index' => 'comment',
        ]);

        return parent::_prepareColumns();
    }

    /**
     * Return url.
     * @param Mage_Catalog_Model_Product|Varien_Object $item Item to get url for.
     * @return string Row Url.
     */
    public function getRowUrl($item): string
    {
        return $this->getUrl('*/*/edit', ['id' => $item->getId()]);
    }
}
