<?php

class Crossroads_SkuWatcher_Helper_Data extends Mage_Core_Helper_Abstract
{
    private $integration;

    public function __construct()
    {
        $this->integration = Mage::getSingleton('core/resource')->getConnection('integration_read');
    }

    public function processOrder($order)
    {
        $items = $order->getAllVisibleItems();

        foreach($items as $item) {
            $product = Mage::getModel('catalog/product')->load($item->getProductId());
            $stockItem = Mage::getModel("cataloginventory/stock_item")->loadByProduct($product);
            if (empty($stockItem)) {
                $stock_qty = null;
            } else {
                $stock_qty = intval($stockItem->getQty());
            }

            $sql = "SELECT * FROM integration.sku_watcher WHERE sku = :sku";
            $result = $this->integration->fetchAll($sql, ["sku" => trim($item->getSku())]);

            foreach ($result as $r) {
                if ($stock_qty === null) {
                    $msg = "SKU: " . $r["sku"] . " (Limit: " . $r["qty"] . ", Stock: none)";
                    $this->sendEmail($r["email"], $msg);
                } elseif ($stock_qty < $r["qty"]) {
                    $msg = "SKU: " . $r["sku"] . " (Limit: " . $r["qty"] . ", Stock: " . $stock_qty . ")";
                    $this->sendEmail($r["email"], $msg);
                } elseif ($r["qty"] == 0) {
                    $msg = "SKU: " . $r["sku"] . " (Limit: 0, Stock: " . $stock_qty . ")";
                    $this->sendEmail($r["email"], $msg);
                }
            }
        }
    }

    public function sendEmail($email, $message)
    {
        mail($email, "SKU Watcher", $message);
    }
}
