<?php

class Crossroads_SkuWatcher_Adminhtml_SkuwatcherController extends Mage_Adminhtml_Controller_Action
{
    /** @var Crossroads_SkuWatcher_Helper_Data */
    private $helper;

    public function _construct()
    {
        $this->helper = Mage::helper('crossroads_skuWatcher');
        parent::_construct();
    }

    /**
     * List of SkuWatcher entries.
     */
    public function indexAction(): void
    {
        $this->_initAction()
            ->_addContent($this->getLayout()->createBlock('crossroads_skuWatcher/skuWatcher'))
            ->renderLayout();
    }

    /**
     * Editor for an existing SkuWatcher entry.
     */
    public function editAction(): void
    {
        $uid = $this->getRequest()->getParam('id');
        $skuWatcher = Mage::getModel('crossroads_skuWatcher/skuWatcher')->load($uid);
        $this->_initAction();
        if ($skuWatcher->exists()) {
            Mage::register('skuWatcher', $skuWatcher);
            $this->_addContent(
                $this->getLayout()->createBlock('crossroads_skuWatcher/skuWatcher_edit')
                    ->assign('header',$this->helper->__('Edit entry'))
                    ->assign('form', $this->getLayout()->createBlock('crossroads_skuWatcher/skuWatcher_edit_form'))
            )->renderLayout();
        } else {
            Mage::getSingleton('adminhtml/session')->addError($this->helper->__('Item does not exist'));
            $this->_redirect('*/*/');
        }
    }

    /**
     * Editor for a new SkuWatcher entry.
     */
    public function newAction(): void
    {
        $skuWatcher = Mage::getModel('crossroads_skuWatcher/skuWatcher');
        Mage::register('skuWatcher', $skuWatcher);
        $this->_initAction();
        $this->_addContent(
            $this->getLayout()->createBlock('crossroads_skuWatcher/skuWatcher_edit')
                ->assign('header', $this->helper->__('New entry'))
                ->assign('form', $this->getLayout()->createBlock('crossroads_skuWatcher/skuWatcher_edit_form'))
        )->renderLayout();
    }

    /**
     * Saving new or existing SkuWatcher entry.
     */
    public function saveAction(): void
    {
        $this->helper = Mage::helper('crossroads_skuWatcher');

        if ($this->getRequest()->getPost()) {
            try {
                $request = $this->getRequest()->getPost();
                $model = Mage::getModel('crossroads_skuWatcher/skuWatcher');
                $uid = $this->getRequest()->getParam('id');
                $model->load($uid);

                $model->setSku($request['sku']);
                $model->setQty($request['qty']);
                $model->setEmail($request['email']);
                $model->setComment($request['comment']);
                $model->save();

                Mage::getSingleton('adminhtml/session')->addSuccess($this->helper->__('Successfully saved.'));
                Mage::getSingleton('adminhtml/session')->setSkuWatcherData(false);

            } catch (Exception $e) {
                Mage::getSingleton('adminhtml/session')->addError($this->helper->__('Invalid data provided.'));
                Mage::getSingleton('adminhtml/session')->setSkuWatcherData($request);
                if ($model->exists()) {
                    $this->_redirect('*/*/edit', ['id' => $uid]);
                } else {
                    $this->_redirect('*/*/new');
                }
                return;
            }
        }
        $this->_redirect('*/*/');
    }

    /**
     * Delete an existing SkuWatcher entry.
     */
    public function deleteAction(): void
    {
        $uid = $this->getRequest()->getParam('id');
        $skuWatcher = Mage::getModel('crossroads_skuWatcher/skuWatcher')->load($uid);
        $this->_initAction();

        if ($skuWatcher->exists()) {
            try {
                $skuWatcher->delete();
                Mage::getSingleton('adminhtml/session')->addSuccess($this->helper->__('Item was successfully deleted'));
                $this->_redirect('*/*/');
            } catch (Exception $e) {
                Mage::getSingleton('adminhtml/session')->addError($e->getMessage());
                $this->_redirect('*/*/edit', ['id' => $uid]);
            }
        }
        $this->_redirect('*/*/');
    }

    /**
     * Init helper method.
     * @return $this
     */
    protected function _initAction(): self
    {
        $this->_title($this->__('Sales'))
             ->_title($this->__('SKU Watcher'));

        $this->loadLayout()
            ->_setActiveMenu('sales/skuWatcher')
            ->_addBreadcrumb($this->helper->__('SKU Watcher'), $this->helper->__('SKU Watcher'))
        ;
        return $this;
    }
}
