<?php

class Crossroads_SkuWatcher_Helper_Data extends Mage_Core_Helper_Abstract
{
    private $integration;

    public function __construct()
    {
        $this->integration = Mage::getSingleton('core/resource')->getConnection('integration_read');
    }

    public function processOrder($order)
    {
        $items = $order->getAllVisibleItems();

        foreach($items as $item) {
            $product = Mage::getModel('catalog/product')->load($item->getProductId());
            $stockItem = Mage::getModel("cataloginventory/stock_item")->loadByProduct($product);
            if (empty($stockItem)) {
                $stock_qty = null;
            } else {
                $stock_qty = intval($stockItem->getQty());
            }
            $productOptions = isset($item->getProductOptions()['options'])
                ? $item->getProductOptions()['options']
                : [];

            $sql = "SELECT * FROM integration.sku_watcher WHERE sku = :sku";
            $result = $this->integration->fetchAll($sql, ["sku" => trim($item->getSku())]);

            foreach ($result as $r) {
                if (count($productOptions) > 0) {
                    $msg = sprintf("%s: %s\n", $item->getSku(), $item->getName());

                    foreach ($productOptions as $option) {
                        $msg .= sprintf("%s: %s\n", $option['label'], $option['print_value']);
                    }
                    $msg .= "\n\n{$r['comment']}";

                    $this->sendEmail($r["email"], $msg);
                }

                if ($stock_qty === null) {
                    $msg = sprintf("SKU: %s (Limit: %d, Stock: none)", $r["sku"], $r["qty"]);
                    $msg .= "\n\n{$r['comment']}";
                    $this->sendEmail($r["email"], $msg);
                } elseif ($stock_qty < $r["qty"]) {
                    $msg = sprintf("SKU: %s (Limit: %d, Stock: %d)", $r["sku"], $r["qty"], $stock_qty);
                    $msg .= "\n\n{$r['comment']}";
                    $this->sendEmail($r["email"], $msg);
                } elseif ($r["qty"] == 0) {
                    $msg = sprintf("SKU: %s (Limit: 0, Stock: %d)", $r["sku"], $stock_qty);
                    $msg .= "\n\n{$r['comment']}";
                    $this->sendEmail($r["email"], $msg);
                }
            }
        }
    }

    public function sendEmail(string $email, string $message)
    {
        try {
            if (empty($message)) {
                throw new Exception('Empty message');
            }
            if (!preg_match('/[\w\.-]+@[\w\.-]+\.[a-z]{2,}/', $email)) {
                throw new Exception('Invalid email address');
            }
            $mail = new Zend_Mail('UTF-8');
            $mail->setBodyText($message)
                ->setFrom('noreply@awardit.com', 'SKU Watcher')
                ->setSubject('SKU Watcher')
                ->addTo($email);
            $mail->send();
            Mage::log("SkuWatcher sent to '{$email}'", Zend_Log::INFO);

        } catch (Exception $e) {
            Mage::log("SkuWatcher failed sending to '{$email}': {$e->getMessage()}", Zend_Log::ERR);
        }
    }
}
