<?php

/**
 * Add SP
 */
class sspmod_addsp_MetaEditor {


	protected function getStandardField($request, &$metadata, $key) {
		if (array_key_exists('field_' . $key, $request)) {
			$metadata[$key] = $request['field_' . $key];
		} else {
			if (isset($metadata[$key])) unset($metadata[$key]);
		}
	}

	protected function getMultipleField($request, &$metadata, $key) {
		if (array_key_exists('field_' . $key, $request)) {
			$metadata[$key] = $request['field_' . $key];
		} else {
			if (isset($metadata[$key])) unset($metadata[$key]);
		}
	}
	
	protected function getEndpointField($request, &$metadata, $key, $binding, $indexed) {
		if (array_key_exists('field_' . $key, $request)) {
			$e = array(
				'Binding' => isset($request['field_' . $key.'Binding'])? $request['field_' . $key.'Binding']: $binding,
				'Location' => $request['field_' . $key]
			);
			if ($indexed) {
				$e['index'] = 0;
			}
			$metadata[$key] = array($e);
		} else {
			if (isset($metadata[$key])) unset($metadata[$key]);
		}
	}

	public function formToMeta($request, $metadata = array(), $override = NULL) {
		$this->getStandardField($request, $metadata, 'entityid');
		$this->getStandardField($request, $metadata, 'name');
		$this->getStandardField($request, $metadata, 'description');
		$this->getEndpointField($request, $metadata, 'AssertionConsumerService', SAML2_Const::BINDING_HTTP_POST, TRUE);
		$this->getEndpointField($request, $metadata, 'SingleLogoutService', SAML2_Const::BINDING_HTTP_REDIRECT, FALSE);

		$this->getStandardField($request, $metadata, 'NameIDFormat', SAML2_Const::NAMEID_TRANSIENT);
		$this->getMultipleField($request, $metadata, 'IDPList');

		if (empty($metadata['NameIDFormat'])) {
			$metadata['NameIDFormat'] = SAML2_Const::NAMEID_TRANSIENT;
		}
		$metadata['updated'] = time();
		
		if ($override) {
			foreach($override AS $key => $value) {
				$metadata[$key] = $value;
			}
		}
		return $metadata;
	}

	protected function requireStandardField($request, $key) {
		if (!array_key_exists('field_' . $key, $request))
			throw new Exception('Required field [' . $key . '] was missing.');
		if (empty($request['field_' . $key]))
			throw new Exception('Required field [' . $key . '] was empty.');
	}

	public function checkForm($request) {
		$this->requireStandardField($request, 'entityid');
		$this->requireStandardField($request, 'name');
	}
	

	protected function header($name) {
		return '<tr ><td>&nbsp;</td><td class="header">' . $name . '</td></tr>';
		
	}
	
	protected function readonlyDateField($metadata, $key, $name) {
		$value = '<span style="color: #aaa">Not set</a>';
		if (array_key_exists($key, $metadata))
			$value = date('j. F Y, G:i', $metadata[$key]);
		return '<tr>
			<td class="name">' . $name . '</td>
			<td class="data">' . $value . '</td></tr>';

	}
	
	protected function readonlyField($metadata, $key, $name) {
		$value = '';
		if (array_key_exists($key, $metadata))
			$value = $metadata[$key];
		return '<tr>
			<td class="name">' . $name . '</td>
			<td class="data">' . htmlspecialchars($value) . '</td></tr>';

	}
	
	protected function hiddenField($key, $value) {
		return '<input type="hidden" name="' . $key . '" value="' . htmlspecialchars($value) . '" />';
	}
	
	protected function flattenLanguageField(&$metadata, $key) {
		if (array_key_exists($key, $metadata)) {
			if (is_array($metadata[$key])) {
				if (isset($metadata[$key]['en'])) {
					$metadata[$key] = $metadata[$key]['en'];
				} else {
					unset($metadata[$key]);
				}
			}
		}
	}
	
	protected function standardField($metadata, $key, $name, $textarea = FALSE) {
		$value = '';
		if (array_key_exists($key, $metadata)) {
			$value = htmlspecialchars($metadata[$key]);
		}
		if ($textarea) {
			return '<tr><td class="name">' . $name . '</td><td class="data">
			<textarea name="field_' . $key . '" rows="5" cols="50">' . $value . '</textarea></td></tr>';
			
		} else {
			return '<tr><td class="name">' . $name . '</td><td class="data">
			<input type="text" size="60" name="field_' . $key . '" value="' . $value . '" /></td></tr>';
			
		}
	}
	
	protected function endpointField($metadata, $key, $name, $textarea = FALSE) {
		$value = '';
		if (array_key_exists($key, $metadata)) {
			if (is_array($metadata[$key])) {
				$value = htmlspecialchars($metadata[$key][0]['Location']);
			} else {
				$value = htmlspecialchars($metadata[$key]);	
			}
			
		}
		
		if ($textarea) {
			return '<tr><td class="name">' . $name . '</td><td class="data">
			<textarea name="field_' . $key . '" rows="5" cols="50">' . $value . '</textarea></td></tr>';
			
		} else {
			return '<tr><td class="name">' . $name . '</td><td class="data">
			<input type="text" size="60" name="field_' . $key . '" value="' . $value . '" /></td></tr>';
			
		}
	}

	protected function bindingField($metadata, $key, $name, $value=SAML2_Const::BINDING_HTTP_REDIRECT) {
		$tmpkey = str_replace("Binding", "", $key);
		if (array_key_exists($tmpkey, $metadata)) {
			if (is_array($metadata[$tmpkey])) {
				$value = htmlspecialchars($metadata[$tmpkey][0]['Binding']);
			} else {
				$value = htmlspecialchars($metadata[$tmpkey]);
			}
			
		}

		return '<tr><td class="name">' . $name . '</td><td class="data">
			<select name="field_' . $key . '">'.
			'<option value="'.SAML2_Const::BINDING_HTTP_REDIRECT.'"'. (($value == SAML2_Const::BINDING_HTTP_REDIRECT)? 'selected="selected"' : '').'>HTTP_REDIRECT</option>'.
			'<option value="'.SAML2_Const::BINDING_HTTP_POST.'"'. (($value == SAML2_Const::BINDING_HTTP_POST)? 'selected="selected"' : '').'>HTTP_POST</option>'.
			'</select></td></tr>';
	}

	protected function trustedIdPsField($metadata, $key, $name) {
		$trustedIdPs = [];
		if (array_key_exists($key, $metadata)) {
			if (is_array($metadata[$key])) {
				$trustedIdPs = $metadata[$key];
			} else {
				$trustedIdPs = $metadata[$key];
			}
		}

		$metadata = \SimpleSAML\Metadata\MetaDataStorageHandler::getMetadataHandler();
		$availableIdPs = $metadata->getList('saml20-idp-remote', true);

		if (!empty($availableIdPs)) {
			$output = '<tr><td class="name">' . $name . '</td><td class="data">';
			foreach ($availableIdPs as $entityid => $set) {
				$output .= '<input style="display: block;float:left;width:20px;" type="checkbox" name="field_'.$key.'[]" value="'.$entityid.'" '.(in_array($entityid, $trustedIdPs)? 'checked="checked"' : '').'/><label style="display: block;float:left;">'.$entityid.'</label></td></tr><td><td class="data">';
			}
			$output .= '</td></tr>';
		}
		return $output;
	}

	public function metaToForm($metadata) {
		$this->flattenLanguageField($metadata, 'name');
		$this->flattenLanguageField($metadata, 'description');
		return '<form action="edit.php" method="post">' .
		
			(array_key_exists('entityid', $metadata) ? 
				$this->hiddenField('was-entityid', $metadata['entityid']) :
				'') .
		
			'<div id="tabdiv">' .
			'<div id="saml"><table class="formtable">' .
				$this->standardField($metadata, 'name', 'Name of the Service') .
				$this->standardField($metadata, 'entityid', 'EntityID') .
				$this->endpointField($metadata, 'AssertionConsumerService', 'Assertion Consumer Service endpoint') .
				$this->bindingField($metadata, 'AssertionConsumerServiceBinding', 'Assertion Consumer Service binding', SAML2_Const::BINDING_HTTP_POST) .
				$this->endpointField($metadata, 'SingleLogoutService', 'Single Logout Service endpoint') .
				$this->bindingField($metadata, 'SingleLogoutServiceBinding', 'Single Logout Service binding', SAML2_Const::BINDING_HTTP_REDIRECT) .
				$this->standardField($metadata, 'NameIDFormat', 'NameID Format') .
				$this->trustedIdPsField($metadata, "IDPList", "Trusted IdPs") .
				$this->readonlyField($metadata, 'owner', 'Owner') .
				$this->readonlyDateField($metadata, 'updated', 'Last updated') .
			'</table></div>' .
			'</div>' .
			'<input type="submit" name="submit" value="Save" style="margin-top: 5px" />' .
		'</form>';
	}
	
}


