<?php
/**
 * Hook to add the addsp module to the frontpage.
 *
 * @param array &$links  The links on the frontpage, split into sections.
 */
function addsp_hook_frontpage(&$links) {
	assert('is_array($links)');
	assert('array_key_exists("links", $links)');

	$links['federation']['addsp'] = array(
		'href' => SimpleSAML_Module::getModuleURL('addsp/index.php'),
		'text' => array('en' => 'Manage Remote Service Providers'),
		'shorttext' => array('en' => 'Manage Remote SPs'),
	);
}
