<?php

$this->data['jquery'] = array('version' => '1.6', 'core' => TRUE, 'ui' => TRUE, 'css' => TRUE);
$this->data['head']  = '<link rel="stylesheet" type="text/css" href="/' . $this->data['baseurlpath'] . 'module.php/addsp/resources/style.css" />' . "\n";
$this->includeAtTemplateBase('includes/header.php');

echo('<div style="float:right;">You are successfully logged in as <b>' . htmlspecialchars($this->data['userid']) . '</b></div>');


echo('<h1>List of Remote Identity Providers registered</h1>');

echo('<table class="metalist" style="width: 100%">');
$i = 0; $rows = array('odd', 'even');
if (empty($this->data['metadata']) || (empty($this->data['metadata']['mine']) && empty($this->data['metadata']['others']))) {
	echo('<p>No Remote Identity Providers registered</p');
} else {
	echo('<tr bgcolor="grey" style="color:white; font-size:larger;"><td>Name</td><td></td></tr>');
	foreach($this->data['metadata']['mine'] AS $md ) {
		$i++;
		echo('<tr class="' . $rows[$i % 2] . '">
			<td width="80%"><a href="edit.php?entityid=' . urlencode($md['entityid']) . '">' . htmlspecialchars($md['name']) . '</a></td>
			<td width="20%">
				| <a href="edit.php?entityid=' . urlencode($md['entityid']) . '">edit</a>
				| <a href="index.php?delete=' . urlencode($md['entityid']) . '">delete</a> |
			</td></tr>');
	}

	foreach($this->data['metadata']['others'] AS $md ) {
		$i++;
		echo('<tr class="' . $rows[$i % 2] . '">
			<td width="80%">' . htmlspecialchars($md['name']) . '</td>
			<td width="20%">' . (isset($md['owner']) ? htmlspecialchars($md['owner']) : 'No owner') . '
			</td></tr>');
	}
	echo('</table>');
}

echo('<br><hr><p>Add new a Remote Identity Provider: <a href="edit.php">Manually</a> | <a href="xmlimport.php">from SAML 2.0 XML metadata</a></p>');

$this->includeAtTemplateBase('includes/footer.php');
