<?php

/**
 * Add IdP
 */
class sspmod_addidp_MetaEditor {


	protected function getStandardField($request, &$metadata, $key) {
		if (array_key_exists('field_' . $key, $request)) {
			$metadata[$key] = $request['field_' . $key];
		} else {
			if (isset($metadata[$key])) unset($metadata[$key]);
		}
	}

	protected function getMultipleField($request, &$metadata, $key) {
		if (array_key_exists('field_' . $key, $request)) {
			$metadata[$key] = $request['field_' . $key];
		} else {
			if (isset($metadata[$key])) unset($metadata[$key]);
		}
	}

	protected function getEndpointField($request, &$metadata, $key, $binding, $indexed) {
		if (array_key_exists('field_' . $key, $request)) {
			$e = array(
				'Binding' => isset($request['field_' . $key.'Binding'])? $request['field_' . $key.'Binding']: $binding,
				'Location' => $request['field_' . $key]
			);
			if ($indexed) {
				$e['index'] = 0;
			}
			$metadata[$key] = array($e);
		} else {
			if (isset($metadata[$key])) unset($metadata[$key]);
		}
	}

	protected function getNameIDFormats($request, &$metadata) {
		if (array_key_exists('field_NameIDFormat', $request)) {
			$metadata['NameIDFormats'] = $request['field_NameIDFormat'];
		} else {
			$metadata['NameIDFormats'] = [SAML2_Const::NAMEID_UNSPECIFIED];
		}
	}

	protected function getCertificateField($request, &$metadata) {
		if (array_key_exists('field_cert', $request)) {
			$value = $request['field_cert'];
			$metadata['keys'] = [];
			$metadata['keys'][0] = [
				'type' => 'X509Certificate',
				'signing' => true,
				'encryption' => false,
				'X509Certificate' => $value
			];
			$metadata['keys'][1] = [
				'type' => 'X509Certificate',
				'signing' => false,
				'encryption' => true,
				'X509Certificate' => $value
            ];
		} else {
			if (isset($metadata['field_cert'])) unset($metadata['field_cert']);
		}
    }

	public function formToMeta($request, $metadata = array(), $override = NULL) {
		$this->getStandardField($request, $metadata, 'entityid');
		$this->getStandardField($request, $metadata, 'name');
		$this->getStandardField($request, $metadata, 'description');
		$this->getEndpointField($request, $metadata, 'SingleSignOnService', SAML2_Const::BINDING_HTTP_REDIRECT, FALSE);
		$this->getEndpointField($request, $metadata, 'SingleLogoutService', SAML2_Const::BINDING_HTTP_REDIRECT, FALSE);
		$this->getMultipleField($request, $metadata, 'IDPList');

		$this->getNameIDFormats($request, $metadata);
		$this->getCertificateField($request, $metadata);

		$metadata['updated'] = time();
		
		if ($override) {
			foreach($override AS $key => $value) {
				$metadata[$key] = $value;
			}
		}

		return $metadata;
	}

	protected function requireStandardField($request, $key) {
		if (!array_key_exists('field_' . $key, $request))
			throw new Exception('Required field [' . $key . '] was missing.');
		if (empty($request['field_' . $key]))
			throw new Exception('Required field [' . $key . '] was empty.');
	}

	public function checkForm($request) {
		$this->requireStandardField($request, 'entityid');
		$this->requireStandardField($request, 'name');
	}
	

	protected function header($name) {
		return '<tr ><td>&nbsp;</td><td class="header">' . $name . '</td></tr>';
		
	}
	
	protected function readonlyDateField($metadata, $key, $name) {
		$value = '<span style="color: #aaa">Not set</a>';
		if (array_key_exists($key, $metadata))
			$value = date('j. F Y, G:i', $metadata[$key]);
		return '<tr>
			<td class="name">' . $name . '</td>
			<td class="data">' . $value . '</td></tr>';

	}
	
	protected function readonlyField($metadata, $key, $name) {
		$value = '';
		if (array_key_exists($key, $metadata))
			$value = $metadata[$key];
		return '<tr>
			<td class="name">' . $name . '</td>
			<td class="data">' . htmlspecialchars($value) . '</td></tr>';

	}
	
	protected function hiddenField($key, $value) {
		return '<input type="hidden" name="' . $key . '" value="' . htmlspecialchars($value) . '" />';
	}
	
	protected function flattenLanguageField(&$metadata, $key) {
		if (array_key_exists($key, $metadata)) {
			if (is_array($metadata[$key])) {
				if (isset($metadata[$key]['en'])) {
					$metadata[$key] = $metadata[$key]['en'];
				} else {
					unset($metadata[$key]);
				}
			}
		}
	}
	
	protected function standardField($metadata, $key, $name, $textarea = FALSE) {
		$value = '';
		if (array_key_exists($key, $metadata)) {
			$value = htmlspecialchars($metadata[$key]);
		}
		if ($textarea) {
			return '<tr><td class="name">' . $name . '</td><td class="data">
			<textarea name="field_' . $key . '" rows="5" cols="50">' . $value . '</textarea></td></tr>';
			
		} else {
			return '<tr><td class="name">' . $name . '</td><td class="data">
			<input type="text" size="60" name="field_' . $key . '" value="' . $value . '" /></td></tr>';
			
		}
	}

	protected function endpointField($metadata, $key, $name, $textarea = FALSE) {
		$value = '';
		if (array_key_exists($key, $metadata)) {
			if (is_array($metadata[$key])) {
				$value = htmlspecialchars($metadata[$key][0]['Location']);
			} else {
				$value = htmlspecialchars($metadata[$key]);	
			}
			
		}
		
		if ($textarea) {
			return '<tr><td class="name">' . $name . '</td><td class="data">
			<textarea name="field_' . $key . '" rows="5" cols="50">' . $value . '</textarea></td></tr>';
			
		} else {
			return '<tr><td class="name">' . $name . '</td><td class="data">
			<input type="text" size="60" name="field_' . $key . '" value="' . $value . '" /></td></tr>';
			
		}
	}

	protected function bindingField($metadata, $key, $name) {
		$tmpkey = str_replace("Binding", "", $key);
		$value = SAML2_Const::BINDING_HTTP_REDIRECT;
		if (array_key_exists($tmpkey, $metadata)) {
			if (is_array($metadata[$tmpkey])) {
				$value = htmlspecialchars($metadata[$tmpkey][0]['Binding']);
			} else {
				$value = htmlspecialchars($metadata[$tmpkey]);
			}
			
		}

		return '<tr><td class="name">' . $name . '</td><td class="data">
			<select name="field_' . $key . '">'.
			'<option value="'.SAML2_Const::BINDING_HTTP_REDIRECT.'"'. (($value == SAML2_Const::BINDING_HTTP_REDIRECT)? 'selected="selected"' : '').'>HTTP_REDIRECT</option>'.
			'<option value="'.SAML2_Const::BINDING_HTTP_POST.'"'. (($value == SAML2_Const::BINDING_HTTP_POST)? 'selected="selected"' : '').'>HTTP_POST</option>'.
			'</select></td></tr>';
	}

	protected function trustedSPsField($metadata, $key, $name) {
		$trustedSPs = [];
		if (array_key_exists($key, $metadata)) {
			if (is_array($metadata[$key])) {
				$trustedSPs = $metadata[$key];
			} else {
				$trustedSPs = $metadata[$key];
			}
		}

		$metadata = \SimpleSAML\Metadata\MetaDataStorageHandler::getMetadataHandler();
		$availableSPs = $metadata->getList('saml20-sp-remote', true);

		if (!empty($availableSPs)) {
			$output = '<tr><td class="name">' . $name . '</td><td class="data">';
			foreach ($availableSPs as $entityid => $set) {
				$output .= '<input style="display: block;float:left;width:20px;" type="checkbox" name="field_'.$key.'[]" value="'.$entityid.'" '.(in_array($entityid, $trustedSPs)? 'checked="checked"' : '').'/><label style="display: block;float:left;">'.$entityid.'</label></td></tr><td><td class="data">';
			}
			$output .= '</td></tr>';
		}
		return $output;
	}

	protected function certField($metadata) {
		$key = 'cert';
		$value = "";
		if (isset($metadata['keys'])) {
			$value = htmlspecialchars($metadata['keys'][0]['X509Certificate']);
		}

		return '<tr><td class="name">X509Certificate</td><td class="data">
			<textarea name="field_' . $key . '" rows="5" cols="50">' . $value . '</textarea></td></tr>';
	}

	protected function nameIdFormatField($metadata) {
		$name = 'NameIDFormat';
		$values = isset($metadata['NameIDFormats'])? $metadata['NameIDFormats']: [];
		$html = '<tr><td class="name">' . $name . 's</td><td class="data">
		<select name="field_'.$name.'[]" multiple>';
		$nameIDFormatValues = $this->nameIDFormatValues();
		foreach ($nameIDFormatValues as $value) {
			$selected_str = '';
			if (in_array($value, $values)) {
				$selected_str = 'selected="selected"';
			}
			$html .= '<option value="'.$value.'"'.$selected_str.' >'.$value.'</option>';
		}

		$html .= '</select>
		</td></tr>';

		return $html;
	}

	protected function nameIDFormatValues() {
		return [
			SAML2_Const::NAMEID_UNSPECIFIED,
			SAML2_Const::NAMEID_EMAIL_ADDRESS,
			SAML2_Const::NAMEID_PERSISTENT,
			SAML2_Const::NAMEID_TRANSIENT,
			SAML2_Const::NAMEID_X509_SUBJECT_NAME,
			SAML2_Const::NAMEID_WINDOWS_DOMAIN_QUALIFIED_NAME,
			SAML2_Const::NAMEID_KERBEROS,
			SAML2_Const::NAMEID_ENTITY,
			SAML2_Const::NAMEID_ENCRYPTED
		];
	}

	public function metaToForm($metadata) {
		$this->flattenLanguageField($metadata, 'name');
		$this->flattenLanguageField($metadata, 'description');
		return '<form action="edit.php" method="post">' .
		
			(array_key_exists('entityid', $metadata) ? 
				$this->hiddenField('was-entityid', $metadata['entityid']) :
				'') .
		
			'<div id="tabdiv">' .
			'<div id="saml"><table class="formtable">' .
				$this->standardField($metadata, 'name', 'Name for the IdP') .
				$this->standardField($metadata, 'entityid', 'EntityID') .
				$this->endpointField($metadata, 'SingleSignOnService', 'Single Sign On Service endpoint') .
				$this->bindingField($metadata, 'SingleSignOnServiceBinding', 'Single Sign On Service binding') .
				$this->endpointField($metadata, 'SingleLogoutService', 'Single Logout Service endpoint') .
				$this->bindingField($metadata, 'SingleLogoutServiceBinding', 'Single Logout Service binding') .
				$this->certField($metadata) .
				$this->nameIdFormatField($metadata) .
				$this->trustedSPsField($metadata, "IDPList", "Trusted SPs") .
				$this->readonlyField($metadata, 'owner', 'Owner') .
				$this->readonlyDateField($metadata, 'updated', 'Last updated') .
			'</table></div>' .
			'</div>' .
			'<input type="submit" name="submit" value="Save" style="margin-top: 5px" />' .
		'</form>';
	}
	
}


