<?php
/**
 * Hook to add the addidp module to the frontpage.
 *
 * @param array &$links  The links on the frontpage, split into sections.
 */
function addidp_hook_frontpage(&$links) {
	assert('is_array($links)');
	assert('array_key_exists("links", $links)');

	$links['federation']['addidp'] = array(
		'href' => SimpleSAML_Module::getModuleURL('addidp/index.php'),
		'text' => array('en' => 'Manage Remote Identity Providers'),
		'shorttext' => array('en' => 'Manage Remote IdPs'),
	);
}
