<?php

class Crossroads_ShippingTrack_Helper_Data extends Mage_Core_Helper_Abstract {

    private $avaliableBringLanguages = array("no", "dk", "fi");
    private $schenkerLanguages = array("sv", "se", "nl", "be", "at", "de", "lu", "lt", "lv", "ee", "gr", "fr", "es", "hu", "it", "ro", "ch", "gb", "pl", "tr", "pt", "ie", "al", "mt", "cy", "bg", "ad", "mc", "sm", "yu", "hr", "si", "ba", "cz");

    private function _ups($trackingNumber)
    {
        return "http://wwwapps.ups.com/WebTracking/processInputRequest?sort_by=status&tracknums_displayed=1&TypeOfInquiryNumber=T&loc=en_EN&InquiryNumber1={$trackingNumber}&track.x=0&track.y=0";
    }

    private function _bring($trackingNumber, $lang)
    {
        switch ($lang) {
            case "no":
                return "https://sporing.posten.no/sporing/{$trackingNumber}";

            case "dk":
                return "https://tracking.bring.dk/tracking/{$trackingNumber}";

            case "fi":
                return "https://tracking.bring.com/tracking/{$trackingNumber}";

            default:
                return "https://tracking.bring.com/tracking/{$trackingNumber}";
        }
    }

    private function _schenker($trackingNumber, $lang)
    {
        if ($lang == "se") {
            return "https://skicka.dbschenker.com/spara/?reference_type=0&reference_number={$trackingNumber}&from=form";
        } else {
            return "https://skicka.dbschenker.com/spara/?reference_type=0&reference_number={$trackingNumber}&from=form&language=en";
        }
    }

    public function getTrackLink($trackingNumber, $countryId)
    {
        if (empty($trackingNumber)) {
            return "";
        }

        if (strtoupper(substr($trackingNumber, 0, 2)) == "1Z") {
            return $this->_ups($trackingNumber);
        }

        $lang = strtolower($countryId);
        if (in_array($lang, $this->avaliableBringLanguages)) {
            return $this->_bring($trackingNumber, $lang);
        }

        return $this->_schenker($trackingNumber, $lang);
    }

}
