<?php

class Crossroads_ShippingTrack_Helper_Data extends Mage_Core_Helper_Abstract
{
  private $avaliablePostNordLanguages = array('se', 'no', 'dk');
  private $avaliableBringLanguages = array('se', 'no', 'dk');
  private $schenkerLanguages = array('sv','se','nl','be','at','de','lu','lt','lv','ee','gr','fr','es','hu','it','ro','ch','gb','pl','tr','pt','ie','al','mt','cy','bg','ad','mc','sm','yu','hr','si','ba','cz');

    private function _ups($trackingNumber) {
        return "http://wwwapps.ups.com/WebTracking/processInputRequest?sort_by=status&tracknums_displayed=1&TypeOfInquiryNumber=T&loc=en_EN&InquiryNumber1=$trackingNumber&track.x=0&track.y=0";
    }

    private function _postNord($trackingNumber, $countryId) {
        $lang = strtolower($countryId);

        if (!in_array($lang, $this->avaliablePostNordLanguages)) {
            $lang = 'en';
        }
        return "https://www.crossroads.se/track/data?id=$trackingNumber&lang=$lang";
    }

    private function _bring($trackingNumber, $countryId)
    {
        $lang = strtolower($countryId);

        if (!in_array($lang, $this->avaliableBringLanguages)) {
          $lang = 'en';
        }

        return "https://www.crossroads.se/track/data?id=$trackingNumber&lang=$lang";
    }

    private function _schenker($trackingNumber, $lang = true)
    {
        return "https://skicka.dbschenker.com/spara/?reference_type=0&reference_number=" . $trackingNumber . "&from=form" . ($lang ? "&language=en" : "");
    }

    public function getTrackLink($trackingNumber, $countryId) {
        if(empty($trackingNumber)) {
            return '';
        }

        if(strtoupper(substr($trackingNumber,0,2)) == '1Z') {
          return $this->_ups($trackingNumber);
        }

        if (substr($trackingNumber, 0, 1) == '3' && (ctype_digit(strval($trackingNumber)) && strlen($trackingNumber) == 18)) {
            if (in_array(strtolower($countryId), $this->schenkerLanguages)) {
                if (in_array(strtolower($countryId), ['se','sv'])) {
                    return $this->_schenker($trackingNumber, false);
                } else {
                    return $this->_schenker($trackingNumber, true);
                }
            } else {
                return $this->_bring($trackingNumber, $countryId);
            }
        }

        return $this->_postNord($trackingNumber, $countryId);
    }
}
