<?php

class Crossroads_Serialcodes_Model_Product_Voucher_Delimiter extends Mage_Eav_Model_Entity_Attribute_Backend_Abstract
{
    /**
     * Before save method
     *
     * @param Varien_Object $object
     * @return $this
     */
    public function beforeSave($object)
    {
        $attrCode = $this->getAttribute()->getAttributeCode();
        if (!$object->hasData($attrCode) && $this->getDefaultValue()) {
            $object->setData($attrCode, $this->getDefaultValue());
        }

        // Saving empty string to Zero-width character
        if ($object->hasData($attrCode) && $object->getData($attrCode) === '') {
            $object->setData($attrCode, '​'); // Zero-width character
        }

        return $this;
    }

    /**
     * After load method
     *
     * @param Varien_Object $object
     * @return $this
     */
    public function afterLoad($object)
    {
        $attrCode = $this->getAttribute()->getAttributeCode();

        // If we don't have a value, return the default value
        if ($object->getData($attrCode) === null && $this->getDefaultValue()) {
            $object->setData($attrCode, $this->getDefaultValue());
        }

        // Translating Zero-width character to empty string
        if ($object->getData($attrCode) === '​') {
            $object->setData($attrCode, '');
        }

        return $this;
    }
}