<?php

use MageQL\Registry;
use MageQL\Type\AbstractBuilder;
use MageQL\Type\InputFieldBuilder;

class Crossroads_Serialcodes_Model_Schema extends MageQL_Core_Model_Schema_Abstract {
    public function getTypeBuilder(string $typeName, Registry $registry): ?AbstractBuilder {
        switch($typeName) {
        case "SerialcodesCode":
            return $this->object("An issued serialcode");

        default:
            return null;
        }
    }

    public function getTypeFields(string $typeName, Registry $registry): array {
        switch($typeName) {
        case "OrderItem":
            return [
                "serialcodes" => $this->field("[SerialcodesCode!]", "List of issued codes if any, will be null if the product will never receive any codes.")
                    ->setResolver("Crossroads_Serialcodes_Model_Schema::resolveSerialcodes"),
            ];

        case "SerialcodesCode":
            return [
                "code" => $this->field("String!", "The issued serialcode"),
                "expiryDate" => $this->field("String", "Expiry date, if any"),
            ];

        default:
            return [];
        }
    }

    /**
     * @return ?Array<array{ code: string, expiryDate: ?string }>
     */
    public static function resolveSerialcodes(Mage_Sales_Model_Order_Item $item): ?array {
        /**
         * @var ?Array<string, array{ code: string, expiryDate: ?string }>
         */
        $codes = null;
        // Include any child items (bundle, config)
        $items = array_merge([$item], $item->getChildrenItems());
        $helper = Mage::helper("serialcodes");

        foreach($items as $i) {
            // All items which are to be assigned serialcodes have a serial code type
            if($i->getSerialCodeType()) {
                $codes = $codes ?: [];
                $itemCodes = array_filter(array_map("trim", explode("\n", $i->getSerialCodes() ?: "")));

                // Manual array merge here since PHP has a tendency to fuck up
                // numbers in arrays:
                foreach($itemCodes as $c) {
                    $codes[$c] = [
                        "code" => $c,
                        "expiryDate" => null,
                    ];
                }
            }
        }

        if( ! $codes) {
            return null;
        }

        foreach($helper->loadCodesAndExpiryDates(array_keys($codes)) as $c) {
            $codes[$c["code"]]["expiryDate"] = date("Y-m-d\TH:i:s\Z", strtotime($c["valid_to"]));
        }

        return array_values($codes);
    }
}
