<?php

$installer = $this;
$setup = Mage::getResourceModel('catalog/setup', 'catalog_setup');
$entityTypeId = (int) Mage::getModel('catalog/product')->getResource()->getEntityType()->getId();

$installer->startSetup();
$conn = $installer->getConnection();

$attributeSetName = 'Gift Cards';
$attributeGroupName = 'Serial Codes';

// https://makandracards.com/magento/6721-product-attribute-addition
$newAttributes = array(
    'serial_code_image_type' => array(
        'label' => 'Select image type',
        'group' => '',
        'sort_order' => 101,
        'backend' => '',
        'type' => 'int',
        'frontend' => '',
        'note' => '',
        'default' => 0,
        'wysiwyg_enabled' => false,
        'input' => 'select',
        'input_renderer' => '',
        'source' => 'serialcodes/product_code_image_types',
        'required' => true,
        'user_defined' => false,
        'unique' => false,
        'global' => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
        'visible' => true,
        'visible_on_front' => false,
        'used_in_product_listing' => false,
        'searchable' => false,
        'visible_in_advanced_search' => false,
        'filterable' => false,
        'filterable_in_search' => false,
        'comparable' => false,
        'is_html_allowed_on_front' => false,
        'apply_to' => 'virtual',
        'is_configurable' => false,
        'used_for_sort_by' => false,
        'position' => 0,
        'used_for_promo_rules' => false,
    ),
    'serial_code_image_params' => array(
        'label' => 'Image parameters',
        'group' => '',
        'sort_order' => 102,
        'backend' => '',
        'type' => 'text',
        'frontend' => '',
        'note' => '',
        'default' => '{}',
        'wysiwyg_enabled' => false,
        'input' => 'text',
        'input_renderer' => '',
        'source' => '',
        'required' => false,
        'user_defined' => false,
        'unique' => false,
        'global' => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
        'visible' => true,
        'visible_on_front' => false,
        'used_in_product_listing' => false,
        'searchable' => false,
        'visible_in_advanced_search' => false,
        'filterable' => false,
        'filterable_in_search' => false,
        'comparable' => false,
        'is_html_allowed_on_front' => false,
        'apply_to' => 'virtual',
        'is_configurable' => false,
        'used_for_sort_by' => false,
        'position' => 0,
        'used_for_promo_rules' => false,
    ),
);

// Fetch id for attribute set
$attributeSetId = $this->getAttributeSetId($entityTypeId, $attributeSetName);
if (!empty($attributeSetId)) {

    // Add all new attributes
    foreach ($newAttributes as $attributeName => $attributeData) {

        // Check if attribute already exists
        if (!$setup->getAttributeId(Mage_Catalog_Model_Product::ENTITY, $attributeName)) {

            // Add attribute
            $setup->addAttribute(Mage_Catalog_Model_Product::ENTITY, $attributeName, $attributeData);

            // Add new attribute to attribute set using attribute group
            $setup->addAttributeToSet($entityTypeId, $attributeSetId, $attributeGroupName, $attributeName, $attributeData['sort_order']);
        } else {
            Mage::log("Attribute with name '{$attributeSetName}' already exists.", LOG_ERR, 'serialcodes.log', true);
        }
    }

} else {
    Mage::log("Attributeset with name '{$attributeSetName}' does not exists.", LOG_ERR, 'serialcodes.log', true);
}

// Magento setup adds new attributes to ALL existing attribute sets
// This removes new attributes from all attribute sets EXCEPT the one we want.
if (!empty($attributeSetId)) {
    $sqlQuery1 = "DELETE FROM eav_entity_attribute WHERE attribute_set_id != :attributeSetId AND attribute_id IN (SELECT attribute_id FROM eav_attribute WHERE attribute_code IN('serial_code_image_type','serial_code_image_params'))";
    $stm1 = Mage::getSingleton('core/resource')->getConnection('core_setup')->prepare($sqlQuery1);
    $stm1->execute(['attributeSetId' => $attributeSetId]);
}
        
// Having problems with is_user_defined not beeing set. This fixes that.
$sqlQuery2 = "UPDATE eav_attribute SET is_user_defined = 1 WHERE attribute_code IN ('serial_code_image_type','serial_code_image_params')";
$stm2 = Mage::getSingleton('core/resource')->getConnection('core_setup')->prepare($sqlQuery2);
$stm2->execute();

$installer->endSetup();
