<?php

class Crossroads_Serialcodes_Serialcodes_TestController extends Mage_Core_Controller_Front_Action
{

    // Run by: /api/serialcodes_test/index
    public function indexAction()
    {
        http_response_code(200);
        die('The end');
    }

    // Run by: /api/serialcodes_test/get
    public function getAction()
    {
        Mage::Helper('Integration')->checkIP();

        $note = 'JoLoTest1';
        $sku = 'JoLoTest';
        $qty = 5;

        $sqlQuery1 = "UPDATE serialcodes SET note = '{$note}', status = 1, update_time = now() WHERE sku = '{$sku}' AND status = 0 ORDER BY serialcodes_id LIMIT {$qty}";
        $affectedRows = Mage::getSingleton('core/resource')->getConnection('integration_write')->exec($sqlQuery1);

        if ($affectedRows != $qty) {
            http_response_code(200);
            die("Wanted to reserve {$qty} codes but only got {$affectedRows}");
        }

        $sqlQuery2 = "SELECT * FROM serialcodes WHERE note = '{$note}'";
        $codes = Mage::getSingleton('core/resource')->getConnection('integration_read')->fetchAll($sqlQuery2);

        $codeQty = count($codes);

        if ($codeQty != $qty) {
            http_response_code(200);
            die("Wanted {$qty} codes but only got {$codeQty}");
        }

        echo '<pre>' . print_r(array_pop($codes), true) . '</pre>';
        echo '<pre>' . print_r(array_pop($codes), true) . '</pre>';
        echo '<pre>' . print_r(array_pop($codes), true) . '</pre>';
        echo '<pre>' . print_r(array_pop($codes), true) . '</pre>';
        echo '<pre>' . print_r(array_pop($codes), true) . '</pre>';
        echo '<pre>' . print_r(array_pop($codes), true) . '</pre>';
    }

    // Run by: /api/serialcodes_test/code
    public function codeAction()
    {
        Mage::Helper('Integration')->checkIP();

        $codes = array(
            'XYZ123693679',
            'XYZ123694493',
            'XYZ123695218',
            'XYZ123696122',
            'XYZ123697947'
        );
        $imageHTML = Mage::Helper('serialcodes')->drawCode(1, $codes);

        echo "<p>Images:{$imageHTML}</p>";

    }

    // Run by: /api/serialcodes_test/db
    public function dbAction()
    {
        Mage::Helper('Integration')->checkIP();

        $sku = 'JoLoTest';
        $codes = array(
            'XYZ123703946',
            'gurka',
            'XYZ123694493',
            "It's a bad, bad string!",
            'XYZ123700492'
        );
        $inStr = '(:param' . implode(',:param', array_keys($codes)) . ')';


        $sqlQuery = "SELECT code, image_hash FROM serialcodes WHERE sku = :sku AND code IN {$inStr}";
        $stmt = Mage::getSingleton('core/resource')->getConnection('integration_read')->prepare($sqlQuery);

        $stmt->bindValue('sku', $sku);
        foreach ($codes as $i => $code) {
            $stmt->bindValue("param{$i}", $code);
        }

        try {
            $stmt->execute();
            $codeData = $stmt->fetchAll(PDO::FETCH_GROUP | PDO::FETCH_UNIQUE);

        } catch (Exception $exception) {
            echo '<p>' . $exception->getMessage() . '</p>';
            echo '<pre>' . $exception->getTraceAsString() . '</pre>';
            echo "<p>{$sqlQuery}</p>";
        }

        echo '<pre>'.print_r($codeData, true).'</pre>';
    }

    // Run by: /api/serialcodes_test/translate
    public function translateAction()
    {
        Mage::Helper('Integration')->checkIP();

        Mage::app()->setCurrentStore(Mage_Core_Model_App::ADMIN_STORE_ID);
        Mage::register("isSecureArea", true);

        $appEmulation = Mage::getSingleton('core/app_emulation');
        $initialEnvironmentInfo = $appEmulation->startEnvironmentEmulation(22); // SE
        echo "<pre>SE:\n";
        echo Mage::Helper('serialcodes')->__('Value code') . "\n";
        echo Mage::Helper('serialcodes')->__('Valid until') . "\n";
        echo Mage::Helper('serialcodes')->__('PIN code') . "\n";
        echo "\n</pre>";

        $appEmulation->startEnvironmentEmulation(37); // EN
        echo "<pre>EN:\n";
        echo Mage::Helper('serialcodes')->__('Value code') . "\n";
        echo Mage::Helper('serialcodes')->__('Valid until') . "\n";
        echo Mage::Helper('serialcodes')->__('PIN code') . "\n";
        echo "\n</pre>";

        $appEmulation->startEnvironmentEmulation(54); // DE
        echo "<pre>DE:\n";
        echo Mage::Helper('serialcodes')->__('Value code') . "\n";
        echo Mage::Helper('serialcodes')->__('Valid until') . "\n";
        echo Mage::Helper('serialcodes')->__('PIN code') . "\n";
        echo "\n</pre>";
        $appEmulation->stopEnvironmentEmulation($initialEnvironmentInfo);
    }

}
