<?php

class Crossroads_Serialcodes_Serialcodes_ImageController extends Mage_Core_Controller_Front_Action
{

    public function getAction()
    {
        $params = $this->getRequest()->getParams();
        $data = array();
        if (!empty($params['hash'])) {
            $hash = rtrim($params['hash'], '.png');
            $sqlQuery = "SELECT * FROM serialcode_images WHERE hash = :hash";
            $data = Mage::getSingleton('core/resource')->getConnection('integration_read')->fetchRow($sqlQuery, array('hash' => $hash));
        }

        if (empty($data['imagedata'])) {
            $baseDir = Mage::getBaseDir('media');
            $locale = Mage::getStoreConfig('general/locale/code', Mage::app()->getStore()->getId());
            $localFilename =  "{$baseDir}/barcodes/default_{$locale}.png";
            if (!is_file($localFilename)) {
                $localFilename = "{$baseDir}/barcodes/default_en_US.png";
            }
            $data = array(
                'created_at' => time(),
                'imagedata' => file_get_contents($localFilename)
            );
        }

        http_response_code(200);
        header('Content-type: image/png');
        header("Content-Length: " . strlen($data['imagedata']));
        header("Content-Disposition: filename={$params['hash']}");
        echo $data['imagedata'];
        exit;
    }

}
