<?php

class Crossroads_Serialcodes_Serialcodes_OrderController extends Mage_Core_Controller_Front_Action {
    public function indexAction() {
        $items  = [];
        $sess   = Mage::getSingleton("checkout/session");
        $order  = Mage::getModel("sales/order")->load($sess->getLastOrderId());
        $helper = Mage::helper("serialcodes");

        if(empty($order) || ! $order->getId()) {
            return $this->getResponse()
              ->setHttpResponseCode(404);
        }

        foreach($order->getAllItems() as $item) {
            if($item->getProduct()->getSerialCodeSerialized()) {
                $codes          = array_filter(array_map("trim", explode("\n", $item->getSerialCodes() ?: "")));
                $codesWithDates = array_combine($codes, array_map(function($code) {
                    return [
                        "code"       => $code,
                        "expiryDate" => null,
                    ];
                }, $codes));

                foreach($helper->loadCodesAndExpiryDates($codes) as $c) {
                    $codesWithDates[$c["code"]]["expiryDate"] = date("Y-m-d\TH:i:s\Z", strtotime($c["valid_to"]));
                }

                $items[] = [
                    "sku"          => $item->getSku(),
                    "parentSku"    => $item->getParentItem() ? $item->getParentItem()->getSku() : null,
                    "name"         => $item->getName(),
                    "requestedQty" => (int)$item->getQtyOrdered(),
                    "codes"        => array_values($codesWithDates),
                ];
            }
        }

        return $this->getResponse()
            ->setHttpResponseCode(200)
            ->setHeader("Content-Type", "application/json")
            ->setBody(json_encode($items));
    }
}
