<?php

$installer = $this;
$setup = Mage::getResourceModel('catalog/setup', 'catalog_setup');
$entityTypeId = (int) Mage::getModel('catalog/product')->getResource()->getEntityType()->getId();

$installer->startSetup();
$conn = $installer->getConnection();

$newAttributes = [
    Crossroads_Serialcodes_Helper_Data::VOUCHER_CODE_DELIMITER => array(
        'label' => 'Voucher code delimiter',
        'group' => '',
        'sort_order' => 18,
        'backend' => 'Crossroads_Serialcodes_Model_Product_Voucher_Delimiter',
        'type' => 'varchar',
        'frontend' => '',
        'note' => 'Delimiter to use when outputting voucher code. Default blank space.',
        'default' => ' ',
        'wysiwyg_enabled' => false,
        'input' => 'select',
        'input_renderer' => '',
        'source' => 'Crossroads_Serialcodes_Model_Product_Attribute_Voucher_Delimiter',
        'required' => false,
        'user_defined' => false,
        'unique' => false,
        'global' => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
        'visible' => true,
        'visible_on_front' => true,
        'used_in_product_listing' => false,
        'searchable' => false,
        'visible_in_advanced_search' => false,
        'filterable' => false,
        'filterable_in_search' => false,
        'comparable' => false,
        'is_html_allowed_on_front' => false,
        'apply_to' => 'virtual',
        'is_configurable' => false,
        'used_for_sort_by' => false,
        'position' => 0,
        'used_for_promo_rules' => false,
    ),
    Crossroads_Serialcodes_Helper_Data::VOUCHER_CODE_GROUP => array(
        'label' => 'Voucher code group',
        'group' => '',
        'sort_order' => 19,
        'backend' => 'Crossroads_Serialcodes_Model_Product_Voucher_Group',
        'type' => 'int',
        'frontend' => '',
        'note' => 'How many chars to group voucher code when outputting. Default 4.',
        'default' => 4,
        'wysiwyg_enabled' => false,
        'input' => 'text',
        'input_renderer' => '',
        'source' => '',
        'required' => false,
        'user_defined' => false,
        'unique' => false,
        'global' => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
        'visible' => true,
        'visible_on_front' => true,
        'used_in_product_listing' => false,
        'searchable' => false,
        'visible_in_advanced_search' => false,
        'filterable' => false,
        'filterable_in_search' => false,
        'comparable' => false,
        'is_html_allowed_on_front' => false,
        'apply_to' => 'virtual',
        'is_configurable' => false,
        'used_for_sort_by' => false,
        'position' => 0,
        'used_for_promo_rules' => false,
    ),
];

$attributeSetName = 'Gift Cards';
$attributeGroupName = 'Serial Codes';
$attributeSetId = $this->getAttributeSetId($entityTypeId, $attributeSetName);

// Create new attribute set
if (!empty($attributeSetId)) {
    // Add all new attributes
    foreach ($newAttributes as $attributeName => $attributeData) {

        // Check if attribute already exists
        if (!$setup->getAttributeId(Mage_Catalog_Model_Product::ENTITY, $attributeName)) {

            // Add attribute
            $setup->addAttribute(Mage_Catalog_Model_Product::ENTITY, $attributeName, $attributeData);

            // Add new attribute to new attribute set using new attribute group
            $setup->addAttributeToSet($entityTypeId, $attributeSetId, $attributeGroupName, $attributeName, $attributeData['sort_order']);
        }
    }
} else {
    Mage::log("Attributeset with name '{$attributeSetName}' does not exists.", LOG_ERR);
}

$installer->endSetup();
