<?php

$installer = $this;

$installer->startSetup();
$conn = $installer->getConnection();

$itemColumns = [
    "serial_code_type" => [
        "type" => Varien_Db_Ddl_Table::TYPE_TEXT,
        "length" => 255,
        "nullable" => true,
        "default" => null,
        "comment" => "Type of serial code",
    ],
    "serial_codes" => [
        "type" => Varien_Db_Ddl_Table::TYPE_TEXT,
        "length" => '64k',
        "nullable" => true,
        "default" => null,
        "comment" => "Serial codes separated by newline",
    ],
];
foreach ($itemColumns as $itemColumn => $spec) {
    $conn->addColumn($this->getTable("sales/order_item"), $itemColumn, $spec);
}

$installer->endSetup();
