<?php

class Crossroads_Serialcodes_SerialcodesController extends Mage_Core_Controller_Front_Action
{

    // Called by /_auc/serialcodes/get_image/hash/<hash>.png
    public function get_imageAction()
    {
        Mage::helper("serialcodes/image")->getImage($this->getRequest()->getParams());
    }

    // Called by /_auc/serialcodes/recreate_images/increment/<increment_id>
    public function recreate_imagesAction()
    {
        Mage::helper("serialcodes/image")->recreateImages($this->getRequest()->getParams());
    }

    // Called by /_auc/serialcodes/create_image/cid/<code_id>/sid/<store_id>
    public function create_imageAction()
    {
        Mage::helper("serialcodes/image")->createImage($this->getRequest()->getParams());
    }

    // Called by /_auc/serialcodes/from_checkout/
    public function from_checkoutAction()
    {
        $items = Mage::helper("serialcodes")->getCodesFromCheckoutSession();

        if ($items === null) {
            return $this->getResponse()->setHttpResponseCode(404);
        } else {
            return $this->getResponse()
                ->setHttpResponseCode(200)
                ->setHeader("Content-Type", "application/json")
                ->setBody(json_encode($items));
        }
    }

}
