<?php

class Crossroads_Serialcodes_Shell_Install {
    protected $_includeMage = false;

    protected $_products = [
        [
            'sku' => 'test-serialcodes-barcode',
            'name' => 'Test serialcodes barcode',
            'image_type' => Crossroads_Serialcodes_Helper_Data::SERIALCODES_IMAGE_BARCODE,
        ],
        [
            'sku' => 'test-serialcodes-qrcode',
            'name' => 'Test serialcodes qrcode',
            'image_type' => Crossroads_Serialcodes_Helper_Data::SERIALCODES_IMAGE_QRCODE,
        ],
        [
            'sku' => 'test-serialcodes-azteccode',
            'name' => 'Test serialcodes azteccode',
            'image_type' => Crossroads_Serialcodes_Helper_Data::SERIALCODES_IMAGE_AZTECCODE,
        ],
        [
            'sku' => 'test-serialcodes-barcode-128c',
            'name' => 'Test serialcodes barcode 128C',
            'image_type' => Crossroads_Serialcodes_Helper_Data::SERIALCODES_IMAGE_BARCODE128C,
        ],
    ];

    public function run() {
        $attribute_set_id = Mage::getModel('eav/entity_attribute_set')
            ->getCollection()
            ->addFieldToFilter('attribute_set_name', 'Gift Cards')
            ->getFirstItem()
            ->getId();

        foreach ($this->_products as $product) {
            $model = Mage::getModel('catalog/product');

            if ($entityId = $model->getIdBySku($product['sku'])) {
                $model->load($entityId);
            }

            $model->addData([
                "store_id" => Mage::app()->getStore()->getId(),
                "website_ids" => [Mage::app()->getStore()->getWebsiteId()],
                "attribute_set_id" => $attribute_set_id,
                "type_id" => "virtual",
                "sku" => $product['sku'],
                "name" => $product['name'],
                //"manufacturer" => $manufacturer,
                "status" => Mage_Catalog_Model_Product_Status::STATUS_ENABLED,
                "tax_class_id" => 2, // Taxable goods, always id 2
                "visibility" => Mage_Catalog_Model_Product_Visibility::VISIBILITY_BOTH,
                "price" => 12.34,
                "description" => "The long product description",
                "short_description" => "The shortest product description",
                "serial_code_serialized" => 1, // Serialcodes enabled
                "serial_code_image_type" => $product['image_type'],
            ]);
            $model->save();
        }
    }
}