<?php

/*
 * source_model in eav_attributes: serialcodes/product_code_image_types
 */

class Crossroads_Serialcodes_Model_Product_Code_Image_Types extends Mage_Eav_Model_Entity_Attribute_Source_Abstract {

    public function getAllOptions()
    {
        if (!$this->_options) {
            $this->_options = [
                [
                    'value' => Crossroads_Serialcodes_Helper_Data::SERIALCODES_IMAGE_NONE,
                    'label' => 'None'
                ],
                [
                    'value' => Crossroads_Serialcodes_Helper_Data::SERIALCODES_IMAGE_BARCODE,
                    'label' => 'BARcode'
                ],
                [
                    'value' => Crossroads_Serialcodes_Helper_Data::SERIALCODES_IMAGE_BARCODE128C,
                    'label' => 'BARcode128C'
                ],
                [
                    'value' => Crossroads_Serialcodes_Helper_Data::SERIALCODES_IMAGE_QRCODE,
                    'label' => 'QRcode'
                ],
                [
                    'value' => Crossroads_Serialcodes_Helper_Data::SERIALCODES_IMAGE_AZTECCODE,
                    'label' => 'AZTECcode'
                ]
            ];
        }
        return $this->_options;
    }

    public function toOptionArray()
    {
        $_options = array();
        if ($this->getAllOptions()) {
            foreach ($this->getAllOptions() as $option) {
                $_options[$option['value']] = $option['label'];
            }
        }
        return $_options;
    }

}
