<?php

class Crossroads_Serialcodes_Model_Observer extends Mage_Core_Controller_Varien_Action
{
    protected $_helper = null;

    public function __construct()
    {
    }

    public function getHelper()
    {
        if (empty($this->_helper)) {
            $this->_helper = Mage::Helper('serialcodes');
        }
        return $this->_helper;
    }

    public function disableSerialCodeAttributes($observer)
    {
        if (Mage::app()->getRequest()->getActionName() == 'edit' || Mage::app()->getRequest()->getParam('type')) {
            $attributes = $observer->getEvent()->getProduct()->getAttributes();
            foreach ($attributes as $attribute) {
                if (strpos($attribute->getAttributeCode(), 'serial_code') !== FALSE) {
                    if (Mage::getSingleton('admin/session')->isAllowed('catalog/serialcodes_attributes')) {
                        $attribute->setIsVisible(1);
                    } else {
                        $attribute->setIsVisible(0);
                    }
                }
            }
        }
    }

    public function issueCodesEvent($observer)
    {
        $order = $observer->getOrder();
        if(empty($order)) {
            return;
        }

        $orderId = $order->getId();
        if(empty($orderId)) {
            return;
        }

        $orderData = $this->getHelper()->getDataForOrder($order);
        // Only process orders that actually contain serial code products
        if (empty($orderData)) {
            return;
        }

        $incrementId = $order->getIncrementId();
        $status = $order->getStatus();
        $sendCustomerEmail = true;

        if (in_array($status, Crossroads_Serialcodes_Helper_Data::$allowedOrderStatuses)) {
            $codeStatus = $this->getHelper()->issueCodesForOrder($order, $sendCustomerEmail);
            if (!empty($codeStatus)) {
                $comment = implode("\n", $codeStatus);
                $this->getHelper()->getLogger()->debug($comment);
                $history = $order->addStatusHistoryComment($comment);
                $history->setIsCustomerNotified(Mage_Sales_Model_Order_Status_History::CUSTOMER_NOTIFICATION_NOT_APPLICABLE);
                $order->save();
            }
        } else {
            /*
            $subject = "Order {$incrementId} have serialcode problems.";
            $body = "Order {$incrementId} have status '{$status}' and is therefore unable to receive serialcodes.\n";
            $body .= "\nView order: https://magento9.crossroads.se/index.php/administration/sales_order/view/order_id/{$orderId}/\n";
            Mage::Helper('Integration')->sendAdminEmail($subject, $body, false);
            */
            $this->getHelper()->getLogger()->info("Order {$incrementId} have status '{$status}' and is therefore unable to receive serialcodes.");
        }
    }

}
