<?php

class Crossroads_Serialcodes_Serialcodes_TestController extends Mage_Core_Controller_Front_Action
{

    public function indexAction()
    {
        die('The end');
    }

    public function getAction()
    {
        Mage::Helper('Integration')->checkIP();

        $note = 'JoLoTest1';
        $sku = 'JoLoTest';
        $qty = 5;

        $sqlQuery1 = "UPDATE integration.serialcodes SET note = '{$note}', status = 1, update_time = now() WHERE sku = '{$sku}' AND status = 0 ORDER BY serialcodes_id LIMIT {$qty}";
        $affectedRows = Mage::getSingleton('core/resource')->getConnection('core_write')->exec($sqlQuery1);

        if ($affectedRows != $qty) {
            die("Wanted to reserve {$qty} codes but only got {$affectedRows}");
        }

        $sqlQuery2 = "SELECT * FROM integration.serialcodes WHERE note = '{$note}'";
        $codes = Mage::getSingleton('core/resource')->getConnection('core_read')->fetchAll($sqlQuery2);

        $codeQty = count($codes);

        if ($codeQty != $qty) {
            die("Wanted {$qty} codes but only got {$codeQty}");
        }

        echo '<pre>' . print_r(array_pop($codes), true) . '</pre>';
        echo '<pre>' . print_r(array_pop($codes), true) . '</pre>';
        echo '<pre>' . print_r(array_pop($codes), true) . '</pre>';
        echo '<pre>' . print_r(array_pop($codes), true) . '</pre>';
        echo '<pre>' . print_r(array_pop($codes), true) . '</pre>';
        echo '<pre>' . print_r(array_pop($codes), true) . '</pre>';
    }

    public function codeAction()
    {
        Mage::Helper('Integration')->checkIP();

        $codes = array(
            'XYZ123693679',
            'XYZ123694493',
            'XYZ123695218',
            'XYZ123696122',
            'XYZ123697947'
        );
        $imageHTML = Mage::Helper('serialcodes')->drawCode(1, $codes);

        echo "<p>Images:{$imageHTML}</p>";

    }

    public function dbAction()
    {
        Mage::Helper('Integration')->checkIP();

        $sku = 'JoLoTest';
        $codes = array(
            'XYZ123703946',
            'gurka',
            'XYZ123694493',
            "It's a bad, bad string!",
            'XYZ123700492'
        );
        $inStr = '(:param' . implode(',:param', array_keys($codes)) . ')';


        $sqlQuery = "SELECT code, image_hash FROM integration.serialcodes WHERE sku = :sku AND code IN {$inStr}";
        $stmt = Mage::getSingleton('core/resource')->getConnection('core_read')->prepare($sqlQuery);

        $stmt->bindValue('sku', $sku);
        foreach ($codes as $i => $code) {
            $stmt->bindValue("param{$i}", $code);
        }

        try {
            $stmt->execute();
            $codeData = $stmt->fetchAll(PDO::FETCH_GROUP | PDO::FETCH_UNIQUE);

        } catch (Exception $exception) {
            echo '<p>' . $exception->getMessage() . '</p>';
            echo '<pre>' . $exception->getTraceAsString() . '</pre>';
            echo "<p>{$sqlQuery}</p>";
        }

        echo '<pre>'.print_r($codeData, true).'</pre>';
    }


}
