<?php

class Crossroads_Serialcodes_Adminhtml_Serialcodes_ItemsController extends Mage_Adminhtml_Controller_Action
{
    protected $_helper = null;

    protected function _initAction()
    {
        $this->loadLayout()
            ->_setActiveMenu('sales/serialcodes_items')
            ->_addBreadcrumb($this->getHelper()->__('Serial Code Items'), $this->getHelper()->__('Serial Code Items'));
        return $this;
    }

    public function getHelper()
    {
        if (empty($this->_helper)) {
            $this->_helper = Mage::Helper('serialcodes');
        }
        return $this->_helper;
    }

    public function indexAction()
    {
        $this->_initAction();
        $this->_addContent($this->getLayout()->createBlock('serialcodes/adminhtml_serialcodes_items'));
        $this->renderLayout();
    }

    public function editAction()
    {
        $itemsId = $this->getRequest()->getParam('id');
        $itemsModel = Mage::getModel('sales/order_item')->load($itemsId);

        if ($itemsModel->getId()) {

            Mage::register('serialcodes_items_data', $itemsModel);

            $this->loadLayout();
            $this->_setActiveMenu('sales/serialcodes_items');

            $this->_addBreadcrumb($this->getHelper()->__('Serial Code Order Items'), $this->getHelper()->__('Serial Code Order Items'));
            $this->_addBreadcrumb($this->getHelper()->__('Edit Codes'), $this->getHelper()->__('Edit Codes'));

            $this->getLayout()->getBlock('head')->setCanLoadExtJs(true);

            $this->_addContent($this->getLayout()->createBlock('serialcodes/adminhtml_serialcodes_items_edit'))
                ->_addLeft($this->getLayout()->createBlock('serialcodes/adminhtml_serialcodes_items_edit_tabs'));

            $this->renderLayout();
        } else {
            Mage::getSingleton('adminhtml/session')->addError($this->getHelper()->__('Item does not exist'));
            $this->_redirect('*/*/');
        }
    }

    public function saveAction()
    {
        if ($this->getRequest()->getPost()) {
            try {
                $postData = $this->getRequest()->getPost();
                $pid = $this->getRequest()->getParam('id');
                $codes = implode("\n", array_filter(array_map('trim', explode("\n", $postData['serial_codes']))));
                $item = Mage::getModel('sales/order_item')->load($pid);
                $item->setSerialCodeType(trim($postData['serial_code_type']))->setSerialCodes($codes)->save();
                Mage::getSingleton('adminhtml/session')->addSuccess($this->getHelper()->__('Successfully saved.'));
                Mage::getSingleton('adminhtml/session')->setSerialcodesData(false);
                $this->_redirect('*/*/');
                return;
            } catch (Exception $e) {
                Mage::getSingleton('adminhtml/session')->addError($e->getMessage());
                Mage::getSingleton('adminhtml/session')->setSerialcodesData($this->getRequest()->getPost());
                $this->_redirect('*/*/edit', array('id' => $this->getRequest()->getParam('id')));
                return;
            }
        }
        $this->_redirect('*/*/');
    }

    public function savepopupAction()
    {
        $orderid = null;
        if ($this->getRequest()->getPost()) {
            try {
                $pid = $this->getRequest()->getParam('id');
                $postData = $this->getRequest()->getPost();
                $codes = implode("\n", array_filter(array_map('trim', explode("\n", $postData['serial_codes_' . $pid]))));
                $item = Mage::getModel('sales/order_item')->load($pid);
                $orderid = $item->getOrderId();
                $oldCodes = $item->getSerialCodes();
                $item->setSerialCodeType(trim($postData['sc_type_' . $pid]))->setSerialCodes($codes)->save();
                Mage::getSingleton('adminhtml/session')->addSuccess($this->getHelper()->__('Successfully saved.'));
                Mage::getSingleton('adminhtml/session')->setSerialcodesData(false);

                $adminUsername = 'system';
                $adminSession = Mage::getSingleton('admin/session');
                if ($adminSession) {
                    $adminUser = $adminSession->getUser();
                    if ($adminUser) {
                        $adminUsername = $adminUser->getUsername();
                    }
                }
                $order = Mage::getSingleton('sales/order')->load($item->getOrderId());
                $productSku = $item->getSku();
                if (empty($codes)) {
                    $history = $order->addStatusHistoryComment("User '{$adminUsername}' removed all codes for [{$productSku}].");
                } elseif(empty($oldCodes)) {
                    $history = $order->addStatusHistoryComment("User '{$adminUsername}' added codes for [{$productSku}].");
                } else {
                    $history = $order->addStatusHistoryComment("User '{$adminUsername}' edited codes for [{$productSku}].");
                }
                $history->setIsCustomerNotified(Mage_Sales_Model_Order_Status_History::CUSTOMER_NOTIFICATION_NOT_APPLICABLE);
                $order->save();

                $this->_redirect('adminhtml/sales_order/view', array('order_id' => $orderid));
                return;
            } catch (Exception $e) {
                Mage::getSingleton('adminhtml/session')->addError($e->getMessage());
                Mage::getSingleton('adminhtml/session')->setSerialcodesData(false);
                $this->_redirect('adminhtml/sales_order/view', array('order_id' => $orderid));
                return;
            }
        }
        $this->_redirect('adminhtml/sales_order/view', array('order_id' => $orderid));
    }

    public function issueAction()
    {
        $pid = $this->getRequest()->getParam('id');
        $order = Mage::getSingleton('sales/order')->load($pid);
        $item = Mage::getSingleton('sales/order_item');
        $storeid = $order->getStoreId();
        $incrementId = $order->getIncrementId();
        $itemIds = explode(',', $this->getRequest()->getPost('sc_items'));
        $this->getHelper()->log(LOG_DEBUG, "Admin issuing codes for order {$incrementId}");
        $adminUsername = 'system';
        $adminSession = Mage::getSingleton('admin/session');
        if ($adminSession) {
            $adminUser = $adminSession->getUser();
            if ($adminUser) {
                $adminUsername = $adminUser->getUsername();
            }
        }
        $messages = [];

        foreach ($itemIds as $itemId) {
            $item->load($itemId);
            $qty = round($item->getQtyOrdered());
            $product = Mage::getModel('catalog/product')->setStoreId($storeid)->load($item->getProductId());
            $productSku = $item->getSku();

            $codes = Mage::Helper('serialcodes')->issueCodesForItem($order, $item, $product, true);

            if ($codes === true) {
                Mage::getSingleton('adminhtml/session')->addSuccess($this->getHelper()->__('%s already have all codes issued.', $product->getName()));
            } elseif ($codes === false) {
                Mage::getSingleton('adminhtml/session')->addError($this->getHelper()->__('Exception while issuing serialcodes for %s.', $product->getName()));
            } elseif (is_numeric($codes)) {
                if ($codes < $qty) {
                    Mage::getSingleton('adminhtml/session')->addError($this->getHelper()->__('Unable to issue all codes for %s.', $product->getName()));
                } elseif ($codes > $qty) {
                    Mage::getSingleton('adminhtml/session')->addError($this->getHelper()->__('Got too many codes for %s.', $product->getName()));
                }
                $messages[] = "User '{$adminUsername}' tried to issue {$qty} codes for [{$productSku}], but got {$codes}";
            } else {
                $issuedQty = count($codes);
                $messages[] = "User '{$adminUsername}' successfully issued {$qty} codes for [{$productSku}].";
                Mage::getSingleton('adminhtml/session')->addSuccess($this->getHelper()->__('Issued %s codes for %s.', $issuedQty, $product->getName()));
            }

            // Check to see if we need to send email about too few available serialcodes
            Mage::Helper('serialcodes')->sendWarningEmail($order, $product);

        }
        if (!empty($messages)) {
            $comment = implode("\n", $messages);
            $history = $order->addStatusHistoryComment($comment);
            $history->setIsCustomerNotified(Mage_Sales_Model_Order_Status_History::CUSTOMER_NOTIFICATION_NOT_APPLICABLE);
            $order->save();
        }

        $this->getHelper()->log(LOG_DEBUG, "Admin done issuing codes\n");
        $this->_redirect('adminhtml/sales_order/view', array('order_id' => $pid));

    }

    public function emailAction()
    {
        $pid = $this->getRequest()->getParam('id');
        $order = Mage::getSingleton('sales/order')->load($pid);
        $storeId = $order->getStoreId();
        $item = Mage::getSingleton('sales/order_item');
        $itemids = explode(',', $this->getRequest()->getPost('sc_items'));
        $adminUsername = 'system';
        $adminSession = Mage::getSingleton('admin/session');
        if ($adminSession) {
            $adminUser = $adminSession->getUser();
            if ($adminUser) {
                $adminUsername = $adminUser->getUsername();
            }
        }
        $messages = [];
        $appEmulation = Mage::getSingleton('core/app_emulation');
        $initialEnvironmentInfo = $appEmulation->startEnvironmentEmulation($storeId);
        foreach ($itemids as $itemid) {
            $item->load($itemid);
            $productId = $item->getProductId();
            $productSku = $item->getSku();
            $product = Mage::getModel('catalog/product')->setStoreId($storeId)->load($productId);
            $qty = round($item->getQtyOrdered());

            $codes = Mage::Helper('serialcodes')->getCodes($order, $item, $product);
            if ($codes === false) {
                Mage::getSingleton('adminhtml/session')->addError($this->getHelper()->__('Exception while fetching serialcodes for %s.', $product->getName()));
            } elseif (is_numeric($codes)) {
                Mage::getSingleton('adminhtml/session')->addError($this->getHelper()->__('Got %s serialcodes but wanted %s for %s.', $codes, $qty, $product->getName()));
            } else {
                Mage::Helper('serialcodes')->sendCustomerEmail($order, $item, $product, $codes, false);
                $messages[] = "User '{$adminUsername}' successfully sent email to customer with {$qty} codes for [{$productSku}].";
                Mage::getSingleton('adminhtml/session')->addSuccess($this->getHelper()->__('An email with serialcodes for %s was sent to %s.', $product->getName(), $order->getCustomerEmail()));
            }
        }
        if (!empty($messages)) {
            $comment = implode("\n", $messages);
            $history = $order->addStatusHistoryComment($comment);
            $history->setIsCustomerNotified(Mage_Sales_Model_Order_Status_History::CUSTOMER_NOTIFICATION_NOT_APPLICABLE);
            $order->save();
        }
        $appEmulation->stopEnvironmentEmulation($initialEnvironmentInfo);
        $this->_redirect('adminhtml/sales_order/view', array('order_id' => $pid));
    }

    public function gridAction()
    {
        $this->loadLayout();
        $this->getResponse()->setBody(
            $this->getLayout()->createBlock('importedit/adminhtml_serialcodes_items_grid')->toHtml()
        );
    }

}
