<?php

// This helper was previously empty, all code here added by Crossroads

class Crossroads_Serialcodes_Helper_Data extends Mage_Core_Helper_Abstract
{
    const TIMEOUT = 5;
    const SERIALCODES_IMAGE_NONE = 0;
    const SERIALCODES_IMAGE_BARCODE = 1;
    const SERIALCODES_IMAGE_QRCODE = 2;
    const SERIALCODES_IMAGE_AZTECCODE = 3;
    const EMAIL_SERIALCODES = 'serialcodes';

    public static $allowedPaymentMethods = array(
        'DibsD2',
        'Dibspw',
        'crossroads_benifybio',
        'crossroads_payex_masterpass',
        'crossroads_vouchers_giftshop',
        'free',
        'julklappsvalet_giftshop',
        'moviestars_points',
    );
    public static $allowedOrderStatuses = array('processing', 'complete');
    public static $imageTypes = array(self::SERIALCODES_IMAGE_BARCODE, self::SERIALCODES_IMAGE_QRCODE, self::SERIALCODES_IMAGE_AZTECCODE);

    protected $_logFile = null;

    public function __construct()
    {
        $this->_logFile = 'serialcodes.log';
    }

    public function getImgHTML($values, $code, $storeId = 0)
    {
        $imgHTML = '';
        $serialCodeImageType = $values['SerialCodeImageType'];
        $sku = $values['sku'];
        $imageParams = $values['SerialCodeImageParams'];

        // Only try to create images if code type is set to something else than 'none'.
        if (in_array($serialCodeImageType, self::$imageTypes)) {
            $sqlQuery = "SELECT code, image_hash FROM integration.serialcodes WHERE sku = :sku AND code = :code";
            $params = [
                'sku' => $sku,
                'code' => $code
            ];
            $codeData = Mage::getSingleton('core/resource')->getConnection('core_read')->fetchRow($sqlQuery, $params);
            $baseUrl = Mage::app()->getStore($storeId)->getBaseUrl();
            $mediaUrl = Mage::app()->getStore($storeId)->getConfig("web/unsecure/base_media_url");

            if (empty($codeData['image_hash'])) {
                switch ($serialCodeImageType) {
                    case self::SERIALCODES_IMAGE_BARCODE:
                        $codeData['image_hash'] = $this->createBARcode($sku, $code, $imageParams);
                        break;

                    case self::SERIALCODES_IMAGE_QRCODE:
                        $codeData['image_hash'] = $this->createQRcode($sku, $code, $imageParams);
                        break;

                    case self::SERIALCODES_IMAGE_AZTECCODE:
                        $codeData['image_hash'] = $this->createAZTECcode($sku, $code, $imageParams);
                        break;

                    default:
                        break;

                }
            }

            if (!empty($codeData['image_hash'])) {
                $imgHTML .= "<table width=\"100%\" class=\"callout\" style=\"Margin-bottom:14px;border-collapse:collapse;border-spacing:0;margin-bottom:14px;padding:0;text-align:left;vertical-align:top\"><tr style=\"padding:0;text-align:left;vertical-align:top\"><th class=\"callout-inner\" style=\"Margin:0;background:#fff;border:none;color:#616161;font-family:Helvetica,Arial,sans-serif;font-size:14px;font-weight:400;line-height:20px;margin:0;padding:14px;text-align:left;width:100%\"><table class=\"row collapse\" style=\"border-collapse:collapse;border-spacing:0;display:table;padding:0;position:relative;text-align:left;vertical-align:top;width:100%\"><tbody><tr style=\"padding:0;text-align:left;vertical-align:top\"><th class=\"small-12 large-4 columns first\" style=\"Margin:0 auto;color:#616161;font-family:Helvetica,Arial,sans-serif;font-size:14px;font-weight:400;line-height:20px;margin:0 auto;padding:0;padding-bottom:0;padding-left:0;padding-right:0;text-align:left;width:190.33px\"><table style=\"border-collapse:collapse;border-spacing:0;padding:0;text-align:left;vertical-align:top;width:100%\"><tr style=\"padding:0;text-align:left;vertical-align:top\"><th style=\"Margin:0;color:#616161;font-family:Helvetica,Arial,sans-serif;font-size:14px;font-weight:400;line-height:20px;margin:0;padding:0;text-align:left\"><center><img align=\"center\" class=\"float-center code__image\" style=\"-ms-interpolation-mode:bicubic;Margin:0 auto;clear:both;display:block;float:none;height:auto!important;margin:0 auto;max-width:100%;outline:0;text-align:center;text-decoration:none;width:auto\" data-f=\"{$baseUrl}\" src=\"{$baseUrl}api/serialcodes_image/get/hash/{$codeData['image_hash']}.png\" /></center></th></tr></table></th>\n";
            } else {
                $baseDir = Mage::getBaseDir('media');
                $locale = Mage::getStoreConfig('general/locale/code', $storeId);
                $localFilename = "{$baseDir}/barcodes/default_{$locale}.png";
                if (is_file($localFilename)) {
                    $imgHTML .= "<table width=\"100%\" class=\"callout\" style=\"Margin-bottom:14px;border-collapse:collapse;border-spacing:0;margin-bottom:14px;padding:0;text-align:left;vertical-align:top\"><tr style=\"padding:0;text-align:left;vertical-align:top\"><th class=\"callout-inner\" style=\"Margin:0;background:#fff;border:none;color:#616161;font-family:Helvetica,Arial,sans-serif;font-size:14px;font-weight:400;line-height:20px;margin:0;padding:14px;text-align:left;width:100%\"><table class=\"row collapse\" style=\"border-collapse:collapse;border-spacing:0;display:table;padding:0;position:relative;text-align:left;vertical-align:top;width:100%\"><tbody><tr style=\"padding:0;text-align:left;vertical-align:top\"><th class=\"small-12 large-4 columns first\" style=\"Margin:0 auto;color:#616161;font-family:Helvetica,Arial,sans-serif;font-size:14px;font-weight:400;line-height:20px;margin:0 auto;padding:0;padding-bottom:0;padding-left:0;padding-right:0;text-align:left;width:190.33px\"><table style=\"border-collapse:collapse;border-spacing:0;padding:0;text-align:left;vertical-align:top;width:100%\"><tr style=\"padding:0;text-align:left;vertical-align:top\"><th style=\"Margin:0;color:#616161;font-family:Helvetica,Arial,sans-serif;font-size:14px;font-weight:400;line-height:20px;margin:0;padding:0;text-align:left\"><center><img align=\"center\" class=\"float-center code__image\" style=\"-ms-interpolation-mode:bicubic;Margin:0 auto;clear:both;display:block;float:none;height:auto!important;margin:0 auto;max-width:100%;outline:0;text-align:center;text-decoration:none;width:auto\" data-f=\"{$baseUrl}\" src=\"{$mediaUrl}barcodes/default_{$locale}.png\" /></center></th></tr></table></th>\n";
                } else {
                    $imgHTML .= "<table width=\"100%\" class=\"callout\" style=\"Margin-bottom:14px;border-collapse:collapse;border-spacing:0;margin-bottom:14px;padding:0;text-align:left;vertical-align:top\"><tr style=\"padding:0;text-align:left;vertical-align:top\"><th class=\"callout-inner\" style=\"Margin:0;background:#fff;border:none;color:#616161;font-family:Helvetica,Arial,sans-serif;font-size:14px;font-weight:400;line-height:20px;margin:0;padding:14px;text-align:left;width:100%\"><table class=\"row collapse\" style=\"border-collapse:collapse;border-spacing:0;display:table;padding:0;position:relative;text-align:left;vertical-align:top;width:100%\"><tbody><tr style=\"padding:0;text-align:left;vertical-align:top\"><th class=\"small-12 large-4 columns first\" style=\"Margin:0 auto;color:#616161;font-family:Helvetica,Arial,sans-serif;font-size:14px;font-weight:400;line-height:20px;margin:0 auto;padding:0;padding-bottom:0;padding-left:0;padding-right:0;text-align:left;width:190.33px\"><table style=\"border-collapse:collapse;border-spacing:0;padding:0;text-align:left;vertical-align:top;width:100%\"><tr style=\"padding:0;text-align:left;vertical-align:top\"><th style=\"Margin:0;color:#616161;font-family:Helvetica,Arial,sans-serif;font-size:14px;font-weight:400;line-height:20px;margin:0;padding:0;text-align:left\"><center><img align=\"center\" class=\"float-center code__image\" style=\"-ms-interpolation-mode:bicubic;Margin:0 auto;clear:both;display:block;float:none;height:auto!important;margin:0 auto;max-width:100%;outline:0;text-align:center;text-decoration:none;width:auto\" data-f=\"{$baseUrl}\" src=\"{$mediaUrl}barcodes/default_en_US.png\" /></center></th></tr></table></th>\n";
                }
            }
        }

        return $imgHTML;
    }

    public function createBARcode($sku, $code, $imageParams = array())
    {
        require_once(Mage::getBaseDir('lib') . '/barcodegen.1d-php5.v5.1.0/class/BCGFontFile.php');
        require_once(Mage::getBaseDir('lib') . '/barcodegen.1d-php5.v5.1.0/class/BCGColor.php');
        require_once(Mage::getBaseDir('lib') . '/barcodegen.1d-php5.v5.1.0/class/BCGDrawing.php');
        require_once(Mage::getBaseDir('lib') . '/barcodegen.1d-php5.v5.1.0/class/BCGcode39.barcode.php');

        try {
            $renderCode = $code;
            if (!empty($imageParams['code_prefix'])) {
                $renderCode = $imageParams['code_prefix'] . $renderCode;
            }
            if (!empty($imageParams['code_suffix'])) {
                $renderCode = $renderCode . $imageParams['code_suffix'];
            }

            $this->log(LOG_DEBUG, "About to create BAR image for [{$sku}] with data '{$renderCode}'");

            // Loading Font
            $font = new BCGFontFile(Mage::getBaseDir('lib') . '/barcodegen.1d-php5.v5.1.0/font/Arial.ttf', 18);

            // The arguments are R, G, B for color.
            $color_black = new BCGColor(0, 0, 0);
            $color_white = new BCGColor(255, 255, 255);

            $drawException = null;
            try {
                $codeImage = new BCGcode39();
                $codeImage->setScale(2); // Resolution
                $codeImage->setThickness(30); // Thickness
                $codeImage->setForegroundColor($color_black); // Color of bars
                $codeImage->setBackgroundColor($color_white); // Color of spaces
                $codeImage->setFont($font); // Font (or 0)
                $codeImage->parse($renderCode); // Text
            } catch (Exception $exception) {
                $drawException = $exception;
            }

            $insertData = array(
                'hash' => md5("SomeStartSalt{$sku}{$code}SomeEndSalt"),
                'imagedata' => null
            );

            $fileName = Mage::getBaseDir('media') . "/barcodes/{$insertData['hash']}.png";

            $drawing = new BCGDrawing($fileName, $color_white);

            if ($drawException) {
                $drawing->drawException($drawException);
            } else {
                $drawing->setBarcode($codeImage);
                $drawing->draw();
            }

            $drawing->finish(BCGDrawing::IMG_FORMAT_PNG);
            $insertData['imagedata'] = file_get_contents($fileName);
            unlink($fileName);

            $sqlQuery1 = "INSERT INTO integration.serialcode_images (hash, imagedata) VALUES (:hash, :imagedata) ON DUPLICATE KEY UPDATE imagedata = VALUES(imagedata)";
            $stm1 = Mage::getSingleton('core/resource')->getConnection('core_write')->prepare($sqlQuery1);
            $stm1->execute($insertData);
            $affectedRows1 = $stm1->rowCount();

            if ($affectedRows1 > 1) {
                // Updated
                $this->log(LOG_DEBUG, "Already have BAR image for hash {$insertData['hash']}");
                return $insertData['hash'];
            } elseif ($affectedRows1 > 0) {
                // Saved, also save hash in serialcodes table
                $this->log(LOG_DEBUG, "Successfully created BAR image with hash {$insertData['hash']}");
                $updateData = array(
                    'hash' => $insertData['hash'],
                    'sku' => $sku,
                    'code' => $code
                );
                $sqlQuery2 = "UPDATE integration.serialcodes SET image_hash = :hash WHERE sku = :sku AND code = :code";
                $stm2 = Mage::getSingleton('core/resource')->getConnection('core_write')->prepare($sqlQuery2);
                $stm2->execute($updateData);
                $affectedRows2 = $stm2->rowCount();
                if ($affectedRows2 < 1) {
                    $this->log(LOG_ERR, 'Unable to update image_hash in serialcodes table.');
                }
                return $insertData['hash'];
            } else {
                // Not saved
                $this->log(LOG_ERR, "Unable to insert/update hash/imagedata.");
            }
        } catch (Exception $exception) {
            // Just silently ignore any error...
            $this->logException($exception, 'Exception while creating BAR code');
        }

        return null;
    }

    public function createQRcode($sku, $code, $imageParams = array())
    {
        require_once(Mage::getBaseDir('lib') . '/phpqrcode/qrlib.php');

        try {
            $insertData = array(
                'hash' => md5("SomeStartSalt{$sku}{$code}SomeEndSalt"),
                'imagedata' => null
            );

            $renderCode = $code;
            if (!empty($imageParams['code_prefix'])) {
                $renderCode = $imageParams['code_prefix'] . $renderCode;
            }
            if (!empty($imageParams['code_suffix'])) {
                $renderCode = $renderCode . $imageParams['code_suffix'];
            }

            $this->log(LOG_DEBUG, "About to create QR image for [{$sku}] with data '{$renderCode}'");
            $fileName = Mage::getBaseDir('media') . "/barcodes/{$insertData['hash']}.png";
            QRcode::png($renderCode, $fileName, QR_ECLEVEL_L, 8);
            $insertData['imagedata'] = file_get_contents($fileName);
            unlink($fileName);

            $sqlQuery1 = "INSERT INTO integration.serialcode_images (hash, imagedata) VALUES (:hash, :imagedata) ON DUPLICATE KEY UPDATE imagedata = VALUES(imagedata), created_at = now()";
            $stm1 = Mage::getSingleton('core/resource')->getConnection('core_write')->prepare($sqlQuery1);
            $stm1->execute($insertData);
            $affectedRows1 = $stm1->rowCount();

            if ($affectedRows1 > 1) {
                // Updated
                $this->log(LOG_DEBUG, "Already have QR image for hash {$insertData['hash']}");
                return $insertData['hash'];
            } elseif ($affectedRows1 > 0) {
                // Saved, also save hash in serialcodes table
                $this->log(LOG_DEBUG, "Successfully created QR image with hash {$insertData['hash']}");
                $updateData = array(
                    'hash' => $insertData['hash'],
                    'sku' => $sku,
                    'code' => $code
                );
                $sqlQuery2 = "UPDATE integration.serialcodes SET image_hash = :hash WHERE sku = :sku AND code = :code";
                $stm2 = Mage::getSingleton('core/resource')->getConnection('core_write')->prepare($sqlQuery2);
                $stm2->execute($updateData);
                $affectedRows2 = $stm2->rowCount();
                if ($affectedRows2 < 1) {
                    $this->log(LOG_ERR, 'Unable to update image_hash in serialcodes table.');
                }
                return $insertData['hash'];
            } else {
                // Not saved
                $this->log(LOG_ERR, "Unable to insert/update hash/imagedata.");
            }
        } catch (Exception $exception) {
            // Just silently ignore any error...
            $this->logException($exception, 'Exception while creating QR code');
        }

        return null;
    }

    public function createAZTECcode($sku, $code, $imageParams = array())
    {
        require_once Mage::getBaseDir('lib') . DS . 'Metzli' . DS . 'Metzli.php';
        $renderFactor = 8; // 8 = 152px x 152px when aztec code is compact

        try {
            $insertData = array(
                'hash' => md5("SomeStartSalt{$sku}{$code}SomeEndSalt"),
                'imagedata' => null
            );

            $renderCode = $code;
            if (!empty($imageParams['code_prefix'])) {
                $renderCode = $imageParams['code_prefix'] . $renderCode;
            }
            if (!empty($imageParams['code_suffix'])) {
                $renderCode = $renderCode . $imageParams['code_suffix'];
            }
            $this->log(LOG_DEBUG, "About to create AZTEC image for [{$sku}] with data '{$renderCode}'");
            $aztecCode = MetzliEncoder::encode($renderCode);
            $renderer = new MetzliPngRenderer($renderFactor);
            $insertData['imagedata'] = $renderer->render($aztecCode);

            $sqlQuery1 = "INSERT INTO integration.serialcode_images (hash, imagedata) VALUES (:hash, :imagedata) ON DUPLICATE KEY UPDATE imagedata = VALUES(imagedata), created_at = now()";
            $stm1 = Mage::getSingleton('core/resource')->getConnection('core_write')->prepare($sqlQuery1);
            $stm1->execute($insertData);
            $affectedRows1 = $stm1->rowCount();

            if ($affectedRows1 > 1) {
                // Updated
                $this->log(LOG_DEBUG, "Already have AZTEC image for hash {$insertData['hash']}");
                return $insertData['hash'];
            } elseif ($affectedRows1 > 0) {
                // Saved, also save hash in serialcodes table
                $this->log(LOG_DEBUG, "Successfully created AZTEC image with hash {$insertData['hash']}");
                $updateData = array(
                    'hash' => $insertData['hash'],
                    'sku' => $sku,
                    'code' => $code
                );
                $sqlQuery2 = "UPDATE integration.serialcodes SET image_hash = :hash WHERE sku = :sku AND code = :code";
                $stm2 = Mage::getSingleton('core/resource')->getConnection('core_write')->prepare($sqlQuery2);
                $stm2->execute($updateData);
                $affectedRows2 = $stm2->rowCount();
                if ($affectedRows2 < 1) {
                    $this->log(LOG_ERR, 'Unable to update image_hash in serialcodes table.');
                }
                return $insertData['hash'];
            } else {
                // Not saved
                $this->log(LOG_ERR, "Unable to insert/update hash/imagedata. hash: {{$insertData['hash']}}");
            }
        } catch (Exception $exception) {
            // Just silently ignore any error...
            $this->logException($exception, 'Exception while creating AZTEC code');
        }

        return null;
    }

    public function getImagesForEmail($itemId, $storeId = 0)
    {
        $retval = array('top' => null, 'bottom' => null);
        $db = Mage::getSingleton('core/resource')->getConnection('core_write');
        $images = $db->fetchAll("SELECT T1.value, T2.store_id, T2.label FROM catalog_product_entity_media_gallery T1 JOIN catalog_product_entity_media_gallery_value T2 ON T2.value_id = T1.value_id WHERE T1.entity_id = ? AND T2.label != ''", $itemId);
        if ($images) {
            foreach ($images as $image) {
                $labelData = explode('_', $image['label']);
                if (!empty($labelData)) {
                    $label = $labelData[0];
                    if (array_key_exists($label, $retval)) {
                        if ($image['store_id'] == $storeId || ($image['store_id'] == 0 && empty($retval[$label]))) {
                            if ($label == 'top') {
                                $retval['background-color'] = empty($labelData[1]) ? 'ffffff' : $labelData[1];
                                $retval['border-color'] = empty($labelData[2]) ? $retval['background-color'] : $labelData[2];
                                $retval['font-color'] = empty($labelData[3]) ? '000000' : $labelData[3];
                            } elseif ($label == 'bottom') {
                                $retval['font-color'] = empty($labelData[1]) ? '000000' : $labelData[1];
                            }
                            $retval[$label] = Mage::getStoreConfig('web/unsecure/base_media_url', $storeId) . 'catalog/product' . $image['value'];
                        }
                    }
                }
            }
        }

        return $retval;
    }

    public function getValidTo($serialcode)
    {
        $db = Mage::getSingleton('core/resource')->getConnection('core_write');

        return $db->fetchOne("SELECT valid_to FROM integration.serialcodes WHERE code = ?", $serialcode);
    }

    public function loadCodesAndExpiryDates($codes)
    {
        if (empty($codes)) {
            return [];
        }

        $conn = Mage::getSingleton("core/resource")->getConnection("core_write");

        $query = $conn->select()
            ->from(["s" => "integration.serialcodes"], ["code", "valid_to"])
            ->where("code IN (?)", $codes)
            ->where("valid_to IS NOT NULL");

        return $conn->query($query)->fetchAll();
    }

    public function issueCodesForOrder($order, $sendCustomerEmail = true)
    {
        $codeStatus = array();

        try {

            $paymentMethod = $order->getPayment()->getMethodInstance()->getCode();
            if (!in_array($paymentMethod, self::$allowedPaymentMethods)) {
                // $this->log(LOG_DEBUG, "Wrong payment method '{$paymentMethod}' for serialcodes.");
                // $codeStatus[] = "Wrong payment method '{$paymentMethod}' for serialcodes.";
                // Do not add this warning to codeStatus. We don't need to spam order history with non essential information.
                return $codeStatus;
            }

            $orderStatus = $order->getStatus();
            if (!in_array($orderStatus, self::$allowedOrderStatuses)) {
                // $this->log(LOG_DEBUG, "Wrong order status '{$orderStatus}' for serialcodes.");
                // $codeStatus[] = "Wrong order state '{$orderState}' for serialcodes.";
                // Do not add this warning to codeStatus. We don't need to spam order history with non essential information.
                return $codeStatus;
            }

            $storeId = $order->getStoreId();
            $incrementId = $order->getIncrementId();
            $orderItems = $order->getItemsCollection()->getItems();

            foreach ($orderItems as $item) {
                $productId = $item->getProductId();
                $qty = round($item->getQtyOrdered());
                $product = Mage::getModel('catalog/product')->setStoreId($storeId)->load($productId);
                $productSku = $product->getSku();
                $sku = trim($product->getData('serial_code_pool'));
                if (empty($sku)) {
                    $sku = trim($product->getSku());
                }

                if ($productId != $product->getId()) {
                    $this->_sendAdminEmail('Unable to load serialcode product', "Order {$incrementId} was unable to load product [{$productSku}]");
                    $this->log(LOG_DEBUG, "Order {$incrementId} was unable to load product [{$productSku}]");
                    $codeStatus[] = "Was unable to load product #{$productId}";
                }

                if ($product->getSerialCodeSerialized()) {

                    $codes = $this->issueCodesForItem($order, $item, $product, true);

                    if ($codes === false) {
                        $this->log(LOG_ERR, "Something went wrong when issuing serialcodes for order {$incrementId}");
                        $codeStatus[] = "Something went wrong when issuing serialcodes for product [{$productSku}]";
                    } elseif ($codes === true) {
                        $this->log(LOG_DEBUG, "Order {$incrementId} already have {$qty} issued serialcodes for [{$productSku}]");
                        $codeStatus[] = "Serialcodes already issued for product [{$productSku}]";
                    } elseif (is_numeric($codes)) {
                        $this->_sendAdminEmail('Unable to get all wanted serialcodes', "Order {$incrementId} was supposed to get {$qty} codes for [{$productSku}] but have {$codes}.");
                        $this->log(LOG_ERR, "Order {$incrementId} was supposed to get {$qty} codes for [{$productSku}] but have {$codes}.");
                        $codeStatus[] = "was supposed to get {$qty} codes for [{$productSku}] but have {$codes}.";
                    } else {

                        // Send email to customer with the issued serialcodes
                        if ($sendCustomerEmail) {
                            $this->sendCustomerEmail($order, $item, $product, $codes);
                            $codeStatus[] = "Successfully sent email to customer with {$qty} codes for [{$productSku}].";
                        }
                    }

                    // Check to see if we need to send email about too few available serialcodes
                    $this->sendWarningEmail($order, $product);
                } else {
                    // $this->log(LOG_DEBUG, "Skipping product [{$productSku}].");
                    // Do not add this warning to codeStatus. We don't need to spam order history with non essential information.
                }
            }

        } catch (Exception $exception) {
            $this->_sendAdminEmail('Exception while issuing serialcode', "Message:\n" . $exception->getMessage() . "\n\nTrace:\n" . $exception->getTraceAsString());
            $this->logException($exception, 'Exception while issuing serialcodes');
            $codeStatus[] = "Exception while issuing serialcodes.";
        }

        return $codeStatus;
    }

    public function issueCodesForItem($order, $item, $product, $updateItem = true)
    {
        $incrementId  = $order->getIncrementId();
        $note         = $this->getNote($order, $item);
        $totalQty     = (int) round($item->getQtyOrdered());
        $sku          = trim($product->getData('serial_code_pool'));
        $db           = Mage::getSingleton("core/resource")->getConnection("core_write");
        $affectedRows = 0;

        if (empty($sku)) {
            $sku = trim($product->getSku());
        }

        // Wait at most 5 seconds on locks
        $db->exec("SET lock_wait_timeout = " . self::TIMEOUT);

        try {
            $db->exec("LOCK TABLES integration.serialcodes WRITE");

            // Try to load codes, to se if they already have been assigned
            $codes = $db->query("SELECT * FROM `integration`.`serialcodes` WHERE `sku` = ? AND `note` = ?", [$sku, $note])->fetchAll();
            $codeQty = count($codes);

            // Check to se if we have all codes
            if ($codeQty < $totalQty) {
                // Nope, we do not have all codes. Try to reserve the missing codes.
                // This query can possibly generate warnings in older MySQL-servers, but is (cluster)safe when using ORDER BY <primary key>
                $wantedCodes  = $totalQty - $codeQty;
                // Use sprintf() since prepared statement breaks on this query
                $q = sprintf("UPDATE `integration`.`serialcodes` SET `note` = %s, `status` = '1', `update_time` = NOW() WHERE `sku` = %s AND `status` = 0 AND (`valid_to` IS NULL OR `valid_to` > DATE(DATE_ADD(NOW(), INTERVAL 14 DAY))) ORDER BY `serialcodes_id` LIMIT %s", $db->quote($note), $db->quote($sku), $db->quote($wantedCodes));
                $affectedRows = $db->query($q)->rowCount();

                // Check to se if we were able to reserve the requested amount of codes
                if ($affectedRows != $wantedCodes) {
                    // No, we were unable to reserve the requested amount of codes. Log this here but handle error later.
                    $this->log(LOG_ERR, "Order {$incrementId} have serialcodes product {$sku} and wanted to reserve {$totalQty} codes but only got {$affectedRows}.");
                }

                $codes = $db->query("SELECT * FROM `integration`.`serialcodes` WHERE `sku` = ? AND `note` = ?", [$sku, $note])->fetchAll();
                $codeQty = count($codes);
            }

            $db->exec("UNLOCK TABLES");

            $this->log(LOG_DEBUG, "Done processing {$note}:{$sku}, has {$codeQty} of requested {$totalQty}, added {$affectedRows} codes.");

            // Check to se if we got all codes
            if ($codeQty == $totalQty) {
                // Serialcodes already issued
                if ($updateItem) {
                    $this->_updateItem($item, $product, $codes);
                }

                // Return true if nothing was changed
                return $affectedRows > 0 ? $codes : true;
            }

            return $codeQty;

        } catch (Exception $e) {
            $db->exec("UNLOCK TABLES");

            Mage::logException($e);

            $this->_sendAdminEmail('Exception while issuing serialcode', "Message:\n" . $e->getMessage() . "\n\nTrace:\n" . $e->getTraceAsString());
            $this->logException($e, 'Exception while issuing serialcode');

            return false;
        }
    }

    private function _updateItem($item, $product, $codes)
    {
        try {
            $previousSerialCodes = $item->getSerialCodes();
            if (empty($previousSerialCodes)) {
                $serialCodes = array();
                foreach ($codes as $code) {
                    $serialCodes[] = $code["code"];
                }

                $codetype = trim($product->getData('serial_code_type'));
                if (empty($codetype)) {
                    $codetype = 'Serial Code';
                }

                $item->setSerialCodeType($codetype);
                $item->setSerialCodes(implode("\n", $serialCodes));
                $item->save();
            }
        } catch (Exception $exception) {
            $this->_sendAdminEmail('Exception while updating item with serialcods', "Message:\n" . $exception->getMessage() . "\n\nTrace:\n" . $exception->getTraceAsString());
            $this->logException($exception, 'Exception while updating item with serialcods');
        }
    }

    public function getCodes($order, $item, $product)
    {
        try {
            $note = $this->getNote($order, $item);
            $qty = round($item->getQtyOrdered());
            $sku = trim($product->getData('serial_code_pool'));
            if (empty($sku)) {
                $sku = trim($product->getSku());
            }

            $sqlQuery1 = "SELECT * FROM integration.serialcodes WHERE sku = '{$sku}' AND note = '{$note}'";
            $codes = Mage::getSingleton('core/resource')->getConnection('core_read')->fetchAll($sqlQuery1);
            $codeQty = count($codes);

            // If we did not get any codes, try fetching from codes stored on item
            if ($codeQty == 0) {
                $serialCodes = explode("\n", $item->getSerialCodes());
                if (!empty($serialCodes)) {
                    $safeSerialCodes = array();
                    foreach ($serialCodes as $code) {
                        $safeSerialCodes[] = trim($code);
                    }
                    if (!empty($safeSerialCodes)) {
                        $safeList = implode("','", $safeSerialCodes);
                        $sqlQuery2 = "SELECT * FROM integration.serialcodes WHERE code IN ('{$safeList}')";
                        $codes = Mage::getSingleton('core/resource')->getConnection('core_read')->fetchAll($sqlQuery2);
                        $codeQty = count($codes);
                    }

                }
            }

            if ($codeQty != $qty) {
                return $codeQty;
            }

            return $codes;

        } catch (Exception $exception) {
            $this->_sendAdminEmail('Exception while fetching serialcodes', "Message:\n" . $exception->getMessage() . "\n\nTrace:\n" . $exception->getTraceAsString());
            $this->logException($exception, 'Exception while fetching serialcodes');
            return false;
        }
    }

    public function sendWarningEmail($order, $product)
    {
        // Check to se if we need to warn about low level of codes
        $email = $product->getData('serial_code_send_warning');
        if (!empty($email)) {
            $sku = trim($product->getData('serial_code_pool'));
            if (empty($sku)) {
                $sku = trim($product->getSku());
            }

            $codetype = trim($product->getData('serial_code_type'));
            if (empty($codetype)) {
                $codetype = 'Serial Code';
            }

            try {
                $db = Mage::getSingleton('core/resource')->getConnection('core_write');

                // Wait at most 5 seconds on locks
                $db->exec("SET lock_wait_timeout = " . self::TIMEOUT);

                $sqlQuery4 = "SELECT count(serialcodes_id) AS qty_free FROM integration.serialcodes WHERE sku = '{$sku}' AND `status` = 0";
                $available = $db->fetchOne($sqlQuery4);

            } catch(Exception $e) {
                Mage::logException($e);

                return;
            }

            $level = $product->getData('serial_code_warning_level');

            if ($available <= $level) {
                $emailvars = array(
                    'product' => $product->getName(),
                    'available' => $available,
                    'none' => !$available,
                    'codetype' => $codetype,
                    'pool' => $sku,
                    'order' => $order
                );
                if (is_numeric($template = $product->getData('serial_code_warning_template'))) {
                    $emailTemplate = Mage::getModel('core/email_template')->load($template);
                } else {
                    $emailTemplate = Mage::getModel('core/email_template')->loadDefault($template);
                }
                $emails = array_filter(array_map('trim', explode(' ', $email)));
                $email = $emails[0];
                unset($emails[0]);
                $emailTemplate->setSenderName(Mage::getStoreConfig('trans_email/ident_sales/name'));
                $emailTemplate->setSenderEmail(Mage::getStoreConfig('trans_email/ident_sales/email'));
                $bccEmails = array_values($emails);
                if (!empty($bccEmails)) {
                    $emailTemplate->addBcc($bccEmails);
                }
                $emailTemplate->send($email, 'Administrator', $emailvars);
            }
        }
    }

    private function _sendAdminEmail($subject, $body)
    {
        $adminEmailAddresses = array(
            'it@crossroads.se'
        );

        foreach ($adminEmailAddresses as $adminEmailAddress) {
            mail($adminEmailAddress, $subject, $body);
        }
    }

    public function sendCustomerEmailForOrder($order)
    {
        $paymentMethod = $order->getPayment()->getMethodInstance()->getCode();
        $orderStatus = $order->getStatus();
        if (!in_array($paymentMethod, self::$allowedPaymentMethods) || !in_array($orderStatus, self::$allowedOrderStatuses)) {
            return;
        }

        $storeId = $order->getStoreId();
        $appEmulation = Mage::getSingleton('core/app_emulation');
        $initialEnvironmentInfo = $appEmulation->startEnvironmentEmulation($storeId);
        $orderItems = $order->getItemsCollection()->getItems();
        foreach ($orderItems as $item) {
            $productId = $item->getProductId();
            $product = Mage::getModel('catalog/product')->setStoreId($storeId)->load($productId);
            $sku = trim($product->getData('serial_code_pool'));
            if (empty($sku)) {
                $sku = trim($product->getSku());
            }

            if ($product->getSerialCodeSerialized()) {
                $codes = $this->getCodes($order, $item, $product);
                if (is_array($codes)) {
                    $this->sendCustomerEmail($order, $item, $product, $codes);
                }
            }
        }
        $appEmulation->stopEnvironmentEmulation($initialEnvironmentInfo);
    }

    public function sendCustomerEmail($order, $item, $product, $codes, $useQueue = true)
    {
        try {
            $productId = $product->getId();
            $storeId = $order->getStoreId();
            $incrementId = $order->getIncrementId();

            $sku = trim($product->getData('serial_code_pool'));
            if (empty($sku)) {
                $sku = trim($product->getSku());
            }

            $serialCodes = array();
            $codeIds = array();
            $valids = array();
            $pin = array();
            foreach ($codes as $code) {
                $serialCodes[] = $code['code'];
                $codeIds[] = $code['serialcodes_id'];
                $valids[$code['code']] = $code['valid_to'];
                $pin[$code['code']] = $code['pin'];
            }

            $mailarray = array();
            $mailarray['sku'] = $sku;
            $mailarray['template'] = $product->getSerialCodeEmailTemplate();
            $mailarray['emailtype'] = $product->getSerialCodeEmailType();
            $mailarray['images'] = $this->getImagesForEmail($productId, $storeId);
            $mailarray['gift_card_text'] = $product->getData('gift_card_text');
            $mailarray['gift_card_terms'] = $product->getData('gift_card_terms');
            $mailarray['store_name'] = Mage::getStoreConfig('general/store_information/name', $storeId);
            $mailarray['store_logo'] = Mage::getStoreConfig('web/unsecure/base_url', $storeId);
            $mailArray['store_secure_base_url'] = Mage::getStoreConfig('web/secure/base_url', $storeId);

            $logoConfig = Mage::getStoreConfig('design/email/logo', $storeId);
            if (!empty($logoConfig)) {
                $mailarray['store_logo'] .= "media/email/logo/{$logoConfig}";
            } else {
                $mailarray['store_logo'] .= 'skin/frontend/';
                $mailarray['store_logo'] .= Mage::getStoreConfig('design/package/name', $storeId) . '/';
                $mailarray['store_logo'] .= Mage::getStoreConfig('design/theme/skin', $storeId) . '/';
                $mailarray['store_logo'] .= 'images/logo_email.gif';
            }

            $mailarray['codes'] = array();
            $mailarray['valids'] = array();
            $mailarray['validshtml'] = '';
            $mailarray['bcc'] = $product->getSerialCodeSendCopy();
            $rawUrl = $product->getData('gift_card_url');

            $mailarray['SerialCodeImageType'] = $product->getSerialCodeImageType();
            $mailarray['SerialCodeImageParams'] = $product->getSerialCodeImageParams();
            if (empty($mailarray['SerialCodeImageParams'])) {
                $mailarray['SerialCodeImageParams'] = array();
            } else {
                $mailarray['SerialCodeImageParams'] = json_decode($mailarray['SerialCodeImageParams'], true);
            }
            $mailarray['generated_codes'] = '';

            $mailarray['codetype'] = $item->getSerialCodeType();
            if (empty($mailarray['codetype'])) {
                $mailarray['codetype'] = 'Serial Code';
            }

            if (empty($mailarray['html'])) {
                $mailarray['html'] = '<div class="sc_items">';
            }
            if ($mailarray['html'] != '<div class="sc_items">') {
                $mailarray['html'] .= '<br /><br />';
            }
            $mailarray['html'] .= '<span class="sc_product">' . $product->getName() . '</span>';

            $mailarray['codes'] = $serialCodes;
            foreach ($serialCodes as $code) {

                $mailarray['generated_codes'] .= $this->getImgHTML($mailarray, $code, $storeId);

                if (empty($rawUrl)) {
                    $mailarray['html'] .= "<br /><span class=\"sc_type\">{$mailarray['codetype']}:</span> <span class=\"sc_code\">{$code}</span>";
                    // Our new email template only uses this case
                    $mailarray['validshtml'] .= "<table width=\"100%\" class=\"callout\" style=\"Margin-bottom:14px;border-collapse:collapse;border-spacing:0;margin-bottom:14px;padding:0;text-align:left;vertical-align:top\"><tr style=\"padding:0;text-align:left;vertical-align:top\"><th class=\"callout-inner\" style=\"Margin:0;background:#fff;border:none;color:#616161;font-family:Helvetica,Arial,sans-serif;font-size:14px;font-weight:400;line-height:20px;margin:0;padding:14px;text-align:left;width:100%\"><table class=\"row collapse\" style=\"border-collapse:collapse;border-spacing:0;display:table;padding:0;position:relative;text-align:left;vertical-align:top;width:100%\"><tbody><tr style=\"padding:0;text-align:left;vertical-align:top\"><th class=\"small-12 large-12 columns first last\" valign=\"middle\" style=\"Margin:0 auto;color:#616161;font-family:Helvetica,Arial,sans-serif;font-size:14px;font-weight:400;line-height:20px;margin:0 auto;padding:0;padding-bottom:0;padding-left:0;padding-right:0;text-align:left;width:557px\"><table style=\"border-collapse:collapse;border-spacing:0;padding:0;text-align:left;vertical-align:top;width:100%\"><tr style=\"padding:0;text-align:left;vertical-align:top\"><th style=\"Margin:0;color:#616161;font-family:Helvetica,Arial,sans-serif;font-size:14px;font-weight:400;line-height:20px;margin:0;padding:0;text-align:left\"><h4 class=\"code__title\" style=\"Margin:0;Margin-bottom:14px;color:#9d9d9d;font-family:Helvetica,Arial,sans-serif;font-size:24px;font-weight:700!important;line-height:20px;margin:0;margin-bottom:14px;padding:0;text-align:center;word-wrap:normal\">" . Mage::helper('serialcodes')->__('Value code') . "</h4><h4 class=\"code__code\" style=\"Margin:0;Margin-bottom:14px;color:#212121 !important;font-family:Helvetica,Arial,sans-serif;font-size:24px;font-weight:700!important;line-height:10px;margin:0;margin-bottom:14px;padding:0;text-align:center;word-wrap:normal;text-decoration: none !important;\">{$code}</h4>";
                    if (!empty($mailarray['generated_codes'])) {
                        //Our new email template only uses this case
                        $mailarray['generated_codes'] .= "<th class=\"small-12 large-8 columns last\" valign=\"middle\" style=\"Margin:0 auto;color:#616161;font-family:Helvetica,Arial,sans-serif;font-size:14px;font-weight:400;line-height:20px;margin:0 auto;padding:0;padding-bottom:0;padding-left:0;padding-right:0;text-align:left;width:373.67px\"><table style=\"border-collapse:collapse;border-spacing:0;padding:0;text-align:left;vertical-align:top;width:100%\"><tr style=\"padding:0;text-align:left;vertical-align:top\"><th style=\"Margin:0;color:#616161;font-family:Helvetica,Arial,sans-serif;font-size:14px;font-weight:400;line-height:20px;margin:0;padding:0;text-align:left\"><h4 class=\"code__title\" style=\"Margin:0;Margin-bottom:14px;color:#9d9d9d;font-family:Helvetica,Arial,sans-serif;font-size:24px;font-weight:700!important;line-height:20px;margin:0;margin-bottom:14px;padding:0;text-align:left;word-wrap:normal\">" . Mage::helper('serialcodes')->__('Value code') . "</h4><h4 class=\"code__code\" style=\"Margin:0;Margin-bottom:14px;color:#212121 !important;font-family:Helvetica,Arial,sans-serif;font-size:24px;font-weight:700!important;line-height:10px;margin:0;margin-bottom:14px;padding:0;text-align:left;word-wrap:normal;text-decoration: none !important;\">{$code}</h4>";
                    }
                } else {
                    $codeUrl = str_replace('%1', $code, $rawUrl);
                    $mailarray['html'] .= "<br /><span class=\"sc_type\">{$mailarray['codetype']}:</span> <span class=\"sc_code\"><a style=\"color:#212121;\" href=\"{$codeUrl}\">{$code}</a></span>";
                    // Our new email template only uses this case
                    $mailarray['validshtml'] .= "<table width=\"100%\" class=\"callout\" style=\"Margin-bottom:14px;border-collapse:collapse;border-spacing:0;margin-bottom:14px;padding:0;text-align:left;vertical-align:top\"><tr style=\"padding:0;text-align:left;vertical-align:top\"><th class=\"callout-inner\" style=\"Margin:0;background:#fff;border:none;color:#616161;font-family:Helvetica,Arial,sans-serif;font-size:14px;font-weight:400;line-height:20px;margin:0;padding:14px;text-align:left;width:100%\"><table class=\"row collapse\" style=\"border-collapse:collapse;border-spacing:0;display:table;padding:0;position:relative;text-align:left;vertical-align:top;width:100%\"><tbody><tr style=\"padding:0;text-align:left;vertical-align:top\"><th class=\"small-12 large-12 columns first last\" valign=\"middle\" style=\"Margin:0 auto;color:#616161;font-family:Helvetica,Arial,sans-serif;font-size:14px;font-weight:400;line-height:20px;margin:0 auto;padding:0;padding-bottom:0;padding-left:0;padding-right:0;text-align:left;width:557px\"><table style=\"border-collapse:collapse;border-spacing:0;padding:0;text-align:left;vertical-align:top;width:100%\"><tr style=\"padding:0;text-align:left;vertical-align:top\"><th style=\"Margin:0;color:#616161;font-family:Helvetica,Arial,sans-serif;font-size:14px;font-weight:400;line-height:20px;margin:0;padding:0;text-align:left\"><h4 class=\"code__title\" style=\"Margin:0;Margin-bottom:14px;color:#9d9d9d;font-family:Helvetica,Arial,sans-serif;font-size:24px;font-weight:700!important;line-height:20px;margin:0;margin-bottom:14px;padding:0;text-align:center;word-wrap:normal\">" . Mage::helper('serialcodes')->__('Value code') . "</h4><h4 class=\"code__code\" style=\"Margin:0;Margin-bottom:14px;color:#212121 !important;font-family:Helvetica,Arial,sans-serif;font-size:24px;font-weight:700!important;line-height:10px;margin:0;margin-bottom:14px;padding:0;text-align:center;word-wrap:normal;text-decoration: none !important;\"><a style=\"color:#212121;\" href=\"{$codeUrl}\">{$code}</a></h4>";
                    if (!empty($mailarray['generated_codes'])) {
                        //Our new email template only uses this case
                        $mailarray['generated_codes'] .= "<th class=\"small-12 large-8 columns last\" valign=\"middle\" style=\"Margin:0 auto;color:#616161;font-family:Helvetica,Arial,sans-serif;font-size:14px;font-weight:400;line-height:20px;margin:0 auto;padding:0;padding-bottom:0;padding-left:0;padding-right:0;text-align:left;width:373.67px\"><table style=\"border-collapse:collapse;border-spacing:0;padding:0;text-align:left;vertical-align:top;width:100%\"><tr style=\"padding:0;text-align:left;vertical-align:top\"><th style=\"Margin:0;color:#616161;font-family:Helvetica,Arial,sans-serif;font-size:14px;font-weight:400;line-height:20px;margin:0;padding:0;text-align:left\"><h4 class=\"code__title\" style=\"Margin:0;Margin-bottom:14px;color:#9d9d9d;font-family:Helvetica,Arial,sans-serif;font-size:24px;font-weight:700!important;line-height:20px;margin:0;margin-bottom:14px;padding:0;text-align:left;word-wrap:normal\">" . Mage::helper('serialcodes')->__('Value code') . "</h4><h4 class=\"code__code\" style=\"Margin:0;Margin-bottom:14px;color:#212121 !important;font-family:Helvetica,Arial,sans-serif;font-size:24px;font-weight:700!important;line-height:10px;margin:0;margin-bottom:14px;padding:0;text-align:left;word-wrap:normal;text-decoration: none !important;\"><a style=\"color:#212121 !important\" href=\"{$codeUrl}\">{$code}</a></h4>";
                    }
                }

                if (!empty($valids[$code])) {
                    $mailarray['html'] .= " <span class=\"sc_valid\">{$valids[$code]}</span>";
                    $mailarray['valids'][] = "{$code}&nbsp;({$valids[$code]})";
                    // Our new email template only uses this case
                    $mailarray['validshtml'] .= "<p class=\"code__validity\" style=\"Margin:0!important;Margin-bottom:14px;color:#616161;font-family:Helvetica,Arial,sans-serif;font-size:14px;font-weight:300!important;line-height:20px;margin:0!important;margin-bottom:14px;padding:0;text-align:center\">" . Mage::helper('serialcodes')->__('Valid until') . "&nbsp;{$valids[$code]}</p>";
                    if (!empty($mailarray['generated_codes'])) {
                        // Our new email template only uses this case
                        $mailarray['generated_codes'] .= "<p class=\"code__validity\" style=\"Margin:0!important;Margin-bottom:14px;color:#616161;font-family:Helvetica,Arial,sans-serif;font-size:14px;font-weight:300!important;line-height:20px;margin:0!important;margin-bottom:14px;padding:0;text-align:left\">" . Mage::helper('serialcodes')->__('Valid until') . "&nbsp;{$valids[$code]}</p>";
                    }
                }

                if (!empty($pin[$code])) {
                    $mailarray['html'] .= " <span class=\"sc_valid\">{$pin[$code]}</span>";
                    $mailarray['pins'][] = "{$code}&nbsp;({$pin[$code]})";
                    // Our new email template only uses this case
                    $mailarray['validshtml'] .= "<p class=\"code__validity\" style=\"Margin:0!important;Margin-bottom:14px;color:#616161;font-family:Helvetica,Arial,sans-serif;font-size:14px;font-weight:300!important;line-height:20px;margin:0!important;margin-bottom:14px;padding:0;text-align:center\">" . Mage::helper('serialcodes')->__('PIN code') . "&nbsp;{$pin[$code]}</p>";
                    if (!empty($mailarray['generated_codes'])) {
                        // Our new email template only uses this case
                        $mailarray['generated_codes'] .= "<p class=\"code__validity\" style=\"Margin:0!important;Margin-bottom:14px;color:#616161;font-family:Helvetica,Arial,sans-serif;font-size:14px;font-weight:300!important;line-height:20px;margin:0!important;margin-bottom:14px;padding:0;text-align:left\">" . Mage::helper('serialcodes')->__('PIN code') . "&nbsp;{$pin[$code]}</p>";
                    }
                }

                if (!empty($mailarray['generated_codes'])) {
                    //Our new email template only uses this case
                    $mailarray['generated_codes'] .= '</th></tr></table></th></tr></tbody></table></th></tr></table>';
                }

                if (!empty($mailarray['validshtml'])) {
                    //Our new email template only uses this case
                    $mailarray['validshtml'] .= '</th></tr></table></th></tr></tbody></table></th></tr></table>';
                }
            }

            if (is_numeric($mailarray['template'])) {
                $emailTemplate = Mage::getModel('core/email_template')->load($mailarray['template']);
            } else {
                $emailTemplate = Mage::getModel('core/email_template')->loadDefault($mailarray['template']);
            }
            $itemstext = strip_tags(str_replace('<br />', "\n", $mailarray['html']));
            $emailvars = array(
                'itemstext' => $itemstext,
                'itemshtml' => $mailarray['html'] . '</div>',
                'codetype' => $mailarray['codetype'],
                'emailtype' => $mailarray['emailtype'],
                'store_name' => $mailarray['store_name'],
                'store_logo' => $mailarray['store_logo'],
                'image_top' => $mailarray['images']['top'],
                'image_bottom' => $mailarray['images']['bottom'],
                'background-color' => $mailarray['images']['background-color'],
                'border-color' => $mailarray['images']['border-color'],
                'font-color' => $mailarray['images']['font-color'],
                'codes' => implode(', ', $mailarray['codes']),
                'validcodes' => implode(', ', $mailarray['valids']),
                'validshtml' => $mailarray['validshtml'],
                'gift_card_text' => $mailarray['gift_card_text'],
                'gift_card_terms' => $mailarray['gift_card_terms'],
                'generated_codes' => $mailarray['generated_codes'],
                'customer_name' => $order->getBillingAddress()->getName(),
                'order' => $order,
                'hasImages' => !empty($mailarray['generated_codes']),
                'hasValidity' => !empty($mailarray['valids']),
                'year' => date('Y'),
                'secure_base_url' => $mailArray['store_secure_base_url'],
            );
            $emailTemplate->setSenderName(Mage::getStoreConfig('trans_email/ident_sales/name', $storeId));
            $emailTemplate->setSenderEmail(Mage::getStoreConfig('trans_email/ident_sales/email', $storeId));
            $bcc = $mailarray['bcc'];
            if ($bcc) {
                $emails = array_filter(array_map('trim', explode(' ', $bcc)));
                $emailTemplate->addBcc($emails);
            }

            $customerEmail = $order->getCustomerEmail();
            if (empty($customerEmail)) {
                $this->_sendAdminEmail('Serialcodes order missing email address', "Order {$incrementId} is missing customer email address.\nThe following codes for product [{$mailarray['sku']}] should have been sent: {$emailvars['codes']}\n");
                $this->log(LOG_ERR, "Order {$incrementId} is missing customer email address.");
            } else {

                if ($useQueue) {
                    /** @var $emailQueue Mage_Core_Model_Email_Queue */
                    $emailQueue = Mage::getModel('core/email_queue');
                    $emailQueue->setEventType(self::EMAIL_SERIALCODES)
                        ->setEntityType(Mage_Sales_Model_Order::ENTITY)
                        ->setEntityId($order->getId())
                        ->setIsForceCheck(false);
                    $emailTemplate->setQueue($emailQueue);
                }

                $emailTemplate->send($customerEmail, $order->getBillingAddress()->getName(), $emailvars);
                $this->log(LOG_DEBUG, "Email sent to {$customerEmail}.");
            }

        } catch (Exception $exception) {
            $this->_sendAdminEmail('Exception while sending customer email with serialcodes', "Message:\n" . $exception->getMessage() . "\n\nTrace:\n" . $exception->getTraceAsString());
            $this->logException($exception, 'Exception while sending customer email with serialcodes');
        }

    }

    public function getDataForOrder($orderId)
    {
        $sqlQuery = "
            SELECT
                o.entity_id,
                o.increment_id,
                o.state,
                o.`status`,
                p.method AS payment_method,
                i.product_id,
                e.sku,
                i.serial_code_type,
                i.serial_codes,
                a.attribute_code,
                ei.`value` AS attribute_value
            FROM sales_flat_order o
            JOIN sales_flat_order_payment p ON p.parent_id = o.entity_id
            JOIN sales_flat_order_item i ON i.order_id = o.entity_id
            JOIN catalog_product_entity e ON e.entity_id = i.product_id
            JOIN catalog_product_entity_int ei ON ei.entity_id = e.entity_id AND ei.store_id = 0
            JOIN eav_attribute a ON a.attribute_id = ei.attribute_id
            WHERE o.entity_id = :entityId AND a.attribute_code = :attributeCode AND ei.`value` = :attributeValue
        ";
        $params = [
            'entityId' => $orderId,
            'attributeCode' => 'serial_code_serialized',
            'attributeValue' => 1
        ];
        return Mage::getSingleton('core/resource')->getConnection('core_read')->fetchAll($sqlQuery, $params);

    }

    public function getNote($order, $item)
    {
        $incrementId = $order->getIncrementId();
        $orderId = $order->getId();
        $itemId = $item->getId();
        $magentoId = Mage::getStoreConfig('integration/general/magento_instance') - 0;
        $note = "{$incrementId}:{$orderId}:{$itemId}:{$magentoId}";

        return $note;
    }

    public function log($logType, $message)
    {
        // $logType: LOG_ERR, LOG_WARNING, LOG_DEBUG
        // $this->log(LOG_DEBUG, "Message");
        Mage::log("{$message}", $logType, $this->_logFile, true);
    }

    public function logException($exception, $messages = array())
    {
        if (!is_array($messages)) {
            $messages = array($messages);
        }

        foreach ($messages as $message) {
            $this->log(LOG_ERR, $message);
        }

        $this->log(LOG_ERR, 'Message: ' . $exception->getMessage());
        $this->log(LOG_ERR, "Trace:\n" . $exception->getTraceAsString());
    }

}
