<?php

declare(strict_types=1);

namespace Fixtures;

use Mage;
use Mage_Customer_Model_Group;
use Mage_SalesRule_Model_Rule;
use Crossroads\Magento\Test\Integration\MagentoManager;

class Rules {
    public function load(): void {
        MagentoManager::init();

        $this->createRules();

        MagentoManager::reset();
    }

    public function createRules(): void {
        $this->createNoShippingRule();
        $this->createShippingRule();
    }

    public function createNoShippingRule(): void {
        $rule = Mage::getModel("salesrule/rule");

        $rule->load("Testregel", "name");

        $rule->addData([
            "name" => "Testregel",
            "uses_per_customer" => 0,
            "customer_group_ids" => [Mage_Customer_Model_Group::NOT_LOGGED_IN_ID],
            "website_ids" => [Mage::app()->getStore()->getWebsiteId()],
            "is_active" => 1,
            "stop_rules_processing" => 0,
            "is_advanced" => 1,
            "sort_order" => 1,
            "simple_action" => "complex_discount",
            "discount_amount" => 0,
            "discount_step" => 3,
            "simple_free_shipping" => 0,
            "apply_to_shipping" => 0,
            "coupon_type" => Mage_SalesRule_Model_Rule::COUPON_TYPE_SPECIFIC,
            "is_rss" => 0,
            "use_auto_generation" => 0,
            "uses_per_coupon" => 1,
        ]);

        $rule->unsConditions();
        $rule->setConditionsSerialized(serialize([
            "type" => "salesrule/rule_condition_combine",
            "attribute" => null,
            "operator" => null,
            "value" => "1",
            "is_value_processed" => null,
            "aggregator" => "all",
        ]));

        $rule->unsActions();
        $rule->setActionsSerialized(serialize([
            "type" => "salesrule/rule_condition_product_combine",
            "attribute" => null,
            "operator" => null,
            "value" => "1",
            "is_value_processed" => null,
            "aggregator" => "all",
        ]));

        $rule->save();

        $this->createThetestCoupon($rule);
        $this->createThepercentCoupon($rule);
        $this->createFreeproductCoupon($rule);
    }

    public function createShippingRule(): void {
        $rule = Mage::getModel("salesrule/rule");

        $rule->load("ShipTestRegel", "name");

        $rule->addData([
            "name" => "ShipTestRegel",
            "uses_per_customer" => 0,
            "customer_group_ids" => [Mage_Customer_Model_Group::NOT_LOGGED_IN_ID],
            "website_ids" => [Mage::app()->getStore()->getWebsiteId()],
            "is_active" => 1,
            "stop_rules_processing" => 0,
            "is_advanced" => 1,
            "sort_order" => 1,
            "simple_action" => "complex_discount",
            "discount_amount" => 0,
            "discount_step" => 3,
            "simple_free_shipping" => 0,
            "apply_to_shipping" => 1,
            "coupon_type" => Mage_SalesRule_Model_Rule::COUPON_TYPE_SPECIFIC,
            "is_rss" => 0,
            "use_auto_generation" => 0,
            "uses_per_coupon" => 1,
        ]);

        $rule->unsConditions();
        $rule->setConditionsSerialized(serialize([
            "type" => "salesrule/rule_condition_combine",
            "attribute" => null,
            "operator" => null,
            "value" => "1",
            "is_value_processed" => null,
            "aggregator" => "all",
        ]));

        $rule->unsActions();
        $rule->setActionsSerialized(serialize([
            "type" => "salesrule/rule_condition_product_combine",
            "attribute" => null,
            "operator" => null,
            "value" => "1",
            "is_value_processed" => null,
            "aggregator" => "all",
        ]));

        $rule->save();

        $this->createFreecoupon($rule);
        $this->create20coupon($rule);
    }

    public function createThetestCoupon($rule) {
        $coupon = Mage::getModel("salesrule/coupon");

        $coupon->load("thetestcoupon", "code");

        $coupon->addData([
            "rule_id" => $rule->getId(),
            "code" => "thetestcoupon",
            "usage_limit" => 1,
            "is_primary" => 0,
            "type" => 0,
        ]);

        $coupon->save();

        $value = Mage::getModel("crossroads_salesrule/coupon_value");

        $value->loadByCouponCode("thetestcoupon");

        $value->addData([
            "coupon_id" => $coupon->getId(),
            "value" => 2,
            "type" => "fixed",
            "description" => "abc123",
        ]);

        $value->save();
    }

    public function createThepercentCoupon($rule) {
        $coupon = Mage::getModel("salesrule/coupon");

        $coupon->load("thepercent", "code");

        $coupon->addData([
            "rule_id" => $rule->getId(),
            "code" => "thepercent",
            "usage_limit" => 1,
            "is_primary" => 0,
            "type" => 0,
        ]);

        $coupon->save();

        $value = Mage::getModel("crossroads_salesrule/coupon_value");

        $value->loadByCouponCode("thepercent");

        $value->addData([
            "coupon_id" => $coupon->getId(),
            "value" => 40,
            "type" => "percent",
            "description" => "abc123",
        ]);

        $value->save();
    }

    public function createFreeproductCoupon($rule) {
        $coupon = Mage::getModel("salesrule/coupon");

        $coupon->load("freeproduct", "code");

        $coupon->addData([
            "rule_id" => $rule->getId(),
            "code" => "freeproduct",
            "usage_limit" => 1,
            "is_primary" => 0,
            "type" => 0,
        ]);

        $coupon->save();

        $value = Mage::getModel("crossroads_salesrule/coupon_value");

        $value->loadByCouponCode("freeproduct");

        $value->addData([
            "coupon_id" => $coupon->getId(),
            "value" => 100,
            "type" => "percent",
            "description" => "abc123",
        ]);

        $value->save();
    }

    public function createFreeCoupon($rule) {
        $coupon = Mage::getModel("salesrule/coupon");

        $coupon->load("free", "code");

        $coupon->addData([
            "rule_id" => $rule->getId(),
            "code" => "free",
            "usage_limit" => 1,
            "is_primary" => 0,
            "type" => 0,
        ]);

        $coupon->save();

        $value = Mage::getModel("crossroads_salesrule/coupon_value");

        $value->loadByCouponCode("free");

        $value->addData([
            "coupon_id" => $coupon->getId(),
            "value" => 100,
            "type" => "percent",
            "description" => "abc123",
        ]);

        $value->save();
    }

    public function create20coupon($rule) {
        $coupon = Mage::getModel("salesrule/coupon");

        $coupon->load("20coupon", "code");

        $coupon->addData([
            "rule_id" => $rule->getId(),
            "code" => "20coupon",
            "usage_limit" => 1,
            "is_primary" => 0,
            "type" => 0,
        ]);

        $coupon->save();

        $value = Mage::getModel("crossroads_salesrule/coupon_value");

        $value->loadByCouponCode("20coupon");

        $value->addData([
            "coupon_id" => $coupon->getId(),
            "value" => 20,
            "type" => "fixed",
            "description" => "abc123",
        ]);

        $value->save();
    }
}
