<?php

declare(strict_types=1);

/**
 * @psalm-scope-this Mage_Core_Model_Resource_Setup
 * @var Mage_Core_Model_Resource_Setup
 */
$installer = $this;

$conn = $installer->getConnection();

$conn->addColumn($installer->getTable("crossroads_salesrule/coupon_value"), "type", [
    "type" => Varien_Db_Ddl_Table::TYPE_TEXT,
    "length" => 255,
    "nullable" => false,
    "default" => "FIXED",
]);

$conn->modifyColumn($installer->getTable("crossroads_salesrule/coupon_value"), "value", [
    "type" => Varien_Db_Ddl_Table::TYPE_DECIMAL,
    "length" => 12,
    "precision" => 4,
    "nullable" => false,
]);

$conn->addColumn($installer->getTable("crossroads_salesrule/coupon_value"), "created_at", [
    "type" => Varien_Db_Ddl_Table::TYPE_TIMESTAMP,
    "nullable" => false,
    "default" => Varien_Db_Ddl_Table::TIMESTAMP_INIT,
]);
$conn->addColumn($installer->getTable("crossroads_salesrule/coupon_value"), "updated_at", [
    "type" => Varien_Db_Ddl_Table::TYPE_TIMESTAMP,
    "nullable" => false,
    "default" => Varien_Db_Ddl_Table::TIMESTAMP_INIT,
]);
