<?php

declare(strict_types=1);

/**
 * @psalm-scope-this Mage_Core_Model_Resource_Setup
 * @var Mage_Core_Model_Resource_Setup
 */
$installer = $this;

$conn = $installer->getConnection();

$table = $conn->newTable($installer->getTable("crossroads_salesrule/coupon_value"))
    ->addColumn("value_id", Varien_Db_Ddl_Table::TYPE_INTEGER, null, [
        "identity" => true,
        "auto_increment" => true,
        "unsigned" => true,
        "nullable" => false,
        "primary" => true,
    ])
    ->addColumn("coupon_id", Varien_Db_Ddl_Table::TYPE_INTEGER, null, [
        "unsigned" => true,
        "nullable" => false,
    ])
    ->addColumn("description", Varien_Db_Ddl_Table::TYPE_TEXT, 255, [
        "nullable" => false,
    ])
    ->addColumn("value", Varien_Db_Ddl_Table::TYPE_DECIMAL, [12, 4], [
        "nullable" => false,
    ])
    ->addColumn("type", Varien_Db_Ddl_Table::TYPE_TEXT, 255, [
        "nullable" => false,
    ])
    ->addColumn("created_at", Varien_Db_Ddl_Table::TYPE_TIMESTAMP, null, [
        "nullable" => false,
        "default" => Varien_Db_Ddl_Table::TIMESTAMP_INIT,
    ])
    ->addColumn("updated_at", Varien_Db_Ddl_Table::TYPE_TIMESTAMP, null, [
        "nullable" => false,
        "default" => Varien_Db_Ddl_Table::TIMESTAMP_INIT,
    ])
    ->addForeignKey(
        $installer->getFkName(
            "crossroads_salesrule/coupon_value",
            "coupon_id",
            "salesrule/coupon",
            "coupon_id"
        ),
        "coupon_id", $installer->getTable("salesrule/coupon"), "coupon_id",
        Varien_Db_Ddl_Table::ACTION_CASCADE, Varien_Db_Ddl_Table::ACTION_CASCADE);
$table->setOption("type", "InnoDB");
$table->setOption("charset", "utf8");

$conn->createTable($table);
