<?php

declare(strict_types=1);

class Crossroads_SalesRule_Model_Resource_Coupon_Value_Collection extends Mage_Core_Model_Resource_Db_Collection_Abstract {
    /**
     * @return void
     */
    protected function _construct() {
        parent::_construct();

        $this->_init("crossroads_salesrule/coupon_value");
    }

    public function filterByCouponCode(string $couponCode): self {
        $this->getSelect()
             ->join(["c" => $this->getTable("salesrule/coupon")], "main_table.coupon_id = c.coupon_id", [])
             ->where("c.code = ?", $couponCode);

        return $this;
    }
}
