<?php

declare(strict_types=1);

class Crossroads_SalesRule_Model_Resource_Coupon_Value extends Mage_Core_Model_Resource_Db_Abstract {
    /**
     * @return void
     */
    protected function _construct() {
        $this->_init("crossroads_salesrule/coupon_value", "value_id");
    }

    public function loadByCouponCode(Crossroads_SalesRule_Model_Coupon_Value $model, string $couponCode): self {
        $coll = $model->getCollection();

        $coll->filterByCouponCode($couponCode);

        // Limit to 1
        $coll->setCurPage(1)->setPageSize(1);

        $item = $coll->getFirstItem();

        if($item && $item->getData($model->getIdFieldName())) {
            $model->setData($item->getData());

            $this->unserializeFields($model);
            $this->_afterLoad($model);
        }

        return $this;
    }
}
