<?php

declare(strict_types=1);

/**
 * @method int getValueId()
 * @method self setValueId(int $id)
 * @method int getCouponId()
 * @method self setCouponId(int $id)
 * @method string getType()
 * @method self setType(string $type)
 * @method float getValue()
 * @method self setValue(float $value)
 * @method string getDescription()
 * @method self setDescription(string $description)
 * @method string getCreatedAt()
 * @method self setCreatedAt(string $timestamp)
 * @method string getUpdatedAt()
 * @method self setUpdatedAt(string $timestamp)
 */
class Crossroads_SalesRule_Model_Coupon_Value extends Mage_Core_Model_Abstract {
    /**
     * Indicates that the value is in a fixed amount.
     */
    const TYPE_FIXED = "fixed";
    /**
     * Indicates that the value is in percent, with 100 being 100%.
     */
    const TYPE_PERCENT = "percent";
    const MIN_VALUE = 0.01;

    /**
     * @return void
     */
    public function _construct() {
        $this->_init("crossroads_salesrule/coupon_value");
    }

    /**
     * @return self
     */
    protected function _beforeSave() {
        parent::_beforeSave();

        $this->setUpdatedAt(gmdate("Y-m-d\\TG:i:s\\Z"));

        return $this;
    }


    public function loadByCouponCode(string $couponCode): self {
        $this->_beforeLoad($couponCode, "coupon_code");

        /**
         * @var Crossroads_SalesRule_Model_Resource_Coupon_Value
         */
        $resource = $this->_getResource();

        $resource->loadByCouponCode($this, $couponCode);

        $this->_afterLoad();
        $this->setOrigData();

        $this->_hasDataChanges = false;

        return $this;
    }
}
